/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.sketchminer.converter;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Coordination;
import org.contextmapper.dsl.contextMappingDSL.CoordinationStep;
import org.contextmapper.dsl.generator.sketchminer.converter.SimplifiedCoordinationStep;
import org.contextmapper.dsl.generator.sketchminer.model.SketchMinerModel;
import org.contextmapper.dsl.generator.sketchminer.model.Task;
import org.contextmapper.dsl.generator.sketchminer.model.TaskSequence;
import org.contextmapper.dsl.generator.sketchminer.model.TaskType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class Coordination2SketchMinerConverter {
    private Coordination coordination;
    private List<SimplifiedCoordinationStep> simplifiedSteps;
    private Map<String, Task> taskMap;
    private SketchMinerModel model;

    public Coordination2SketchMinerConverter(Coordination coordination) {
        this.coordination = coordination;
        this.model = new SketchMinerModel(this.getDefaultActorName(coordination));
        this.initIntermediateTypes();
    }

    public SketchMinerModel convert() {
        TaskSequence seq = new TaskSequence(this.simplifiedSteps.get(0).getOperation());
        this.model.addSequence(seq);
        this.finishSequence(seq);
        return this.model;
    }

    private void finishSequence(TaskSequence seq) {
        for (int i = 1; i < this.simplifiedSteps.size(); ++i) {
            seq.addTask(this.simplifiedSteps.get(i).getOperation());
        }
    }

    private void initIntermediateTypes() {
        this.simplifiedSteps = Lists.newLinkedList();
        this.taskMap = new HashMap<String, Task>();
        for (CoordinationStep step : this.coordination.getCoordinationSteps()) {
            this.simplifiedSteps.add(this.convert(step));
        }
    }

    private SimplifiedCoordinationStep convert(CoordinationStep step) {
        Task operation = this.getOrCreateTask(step, TaskType.COMMAND);
        return new SimplifiedCoordinationStep(operation);
    }

    private Task getOrCreateTask(CoordinationStep step, TaskType type) {
        String taskName = step.getService().getName() + "." + step.getOperation().getName();
        String taskMapKey = step.getBoundedContext().getName() + "." + taskName;
        if (this.taskMap.containsKey(taskMapKey)) {
            return this.taskMap.get(taskMapKey);
        }
        Task task = new Task(taskName, type);
        task.setActor(step.getBoundedContext().getName());
        this.taskMap.put(taskMapKey, task);
        return task;
    }

    private String getDefaultActorName(Coordination coordination) {
        if (EcoreUtil2.getRootContainer((EObject)coordination) instanceof ContextMappingModel) {
            return new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)coordination)).resolveBoundedContext(coordination).getName();
        }
        return "Application";
    }
}

