/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.Volatility;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.ContextMappingModelHelper;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;

public class ExtractAggregatesByVolatility
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String boundedContextName;
    private BoundedContext originalBC;
    private Volatility likelihoodForChange;

    public ExtractAggregatesByVolatility(String boundedContextName, Volatility likelihoodForChange) {
        this.boundedContextName = boundedContextName;
        this.likelihoodForChange = likelihoodForChange;
    }

    @Override
    protected void doRefactor() {
        this.initOriginalBC();
        if (this.originalBC.getAggregates().size() < 2) {
            return;
        }
        List<Aggregate> aggregates = this.collectAggregatesByVolatility();
        if (aggregates.size() < 1) {
            return;
        }
        BoundedContext newBC = this.createNewBoundedContext();
        for (Aggregate aggregate : aggregates) {
            this.addElementToEList(newBC.getAggregates(), aggregate);
            this.removeElementFromEList(this.originalBC.getAggregates(), aggregate);
        }
        this.addElementToEList(this.getResource(this.originalBC).getContextMappingModel().getBoundedContexts(), newBC);
        for (ContextMap contextMap : this.getAllContextMaps()) {
            new ContextMappingModelHelper(contextMap).moveExposedAggregatesToNewRelationshipsIfNeeded(aggregates.stream().map(a -> a.getName()).collect(Collectors.toList()), newBC);
        }
    }

    private BoundedContext createNewBoundedContext() {
        BoundedContext newBC = ContextMappingDSLFactory.eINSTANCE.createBoundedContext();
        newBC.setName(this.boundedContextName + "_Volatility_" + this.likelihoodForChange.getName());
        return newBC;
    }

    private List<Aggregate> collectAggregatesByVolatility() {
        return this.originalBC.getAggregates().stream().filter(agg -> agg.getLikelihoodForChange().equals((Object)this.likelihoodForChange)).collect(Collectors.toList());
    }

    private void initOriginalBC() {
        List bcsWithGivenInputName = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.boundedContextName)).collect(Collectors.toList());
        this.originalBC = (BoundedContext)bcsWithGivenInputName.get(0);
    }
}

