/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class BoundedContextSemanticsValidator
extends AbstractDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void validateThatAggregateContainsOnlyOneAggregateRoot(BoundedContext boundedContext) {
        List domains = boundedContext.getImplementedDomainParts().stream().filter(domainPart -> domainPart instanceof Domain).map(domainPart -> (Domain)domainPart).collect(Collectors.toList());
        if (domains.isEmpty()) {
            return;
        }
        boundedContext.getImplementedDomainParts().stream().filter(domainPart -> domainPart instanceof Subdomain).map(domainPart -> (Subdomain)domainPart).forEach(subdomain -> {
            Domain parentDomain = (Domain)subdomain.eContainer();
            if (domains.contains(parentDomain)) {
                this.error(String.format("The subdomain '%s' is already implemented through its domain '%s'.", subdomain.getName(), parentDomain.getName()), boundedContext, (EStructuralFeature)ContextMappingDSLPackage.Literals.BOUNDED_CONTEXT__IMPLEMENTED_DOMAIN_PARTS, boundedContext.getImplementedDomainParts().indexOf(subdomain));
            }
        });
    }

    @Check
    public void warnUserIfABoundedContextImplementsMultipleDomains(BoundedContext boundedContext) {
        List domains = boundedContext.getImplementedDomainParts().stream().filter(domainPart -> domainPart instanceof Domain).map(domainPart -> (Domain)domainPart).collect(Collectors.toList());
        if (domains.size() > 1) {
            for (Domain domain : domains) {
                this.warning("Are you sure you want to implement multiple Domains within one Bounded Context? A Bounded Context should typically implement only a part of your Domain; one or multiple Subdomains.", boundedContext, (EStructuralFeature)ContextMappingDSLPackage.Literals.BOUNDED_CONTEXT__IMPLEMENTED_DOMAIN_PARTS, boundedContext.getImplementedDomainParts().indexOf((Object)domain));
            }
        }
    }
}

