/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl;

import org.contextmapper.dsl.generator.mdsl.ProtectedRegionContext;
import org.contextmapper.dsl.generator.mdsl.ProtectedRegionIdentifier;
import org.contextmapper.dsl.generator.mdsl.ProtectedRegionReader;

public class ProtectedRegionContextFactory {
    public ProtectedRegionContext createProtectedRegionContextForNewMDSLFile() {
        ProtectedRegionContext context = new ProtectedRegionContext();
        context.setProtectedDataTypeRegion("");
        context.setProtectedEndpointRegion("");
        context.setProtectedProviderRegion("");
        context.setProtectedClientRegion("");
        return context;
    }

    public ProtectedRegionContext createProtectedRegionContextForExistingMDSLFile(String fileContent) {
        ProtectedRegionContext context = new ProtectedRegionContext();
        ProtectedRegionReader reader = new ProtectedRegionReader();
        String protectedSectionDataTypes = reader.getProtectedRegionContent(fileContent, ProtectedRegionIdentifier.DATA_TYPE_REGION);
        String protectedSectionEndpoints = reader.getProtectedRegionContent(fileContent, ProtectedRegionIdentifier.ENDPOINT_REGION);
        String protectedSectionProviders = reader.getProtectedRegionContent(fileContent, ProtectedRegionIdentifier.PROVIDER_REGION);
        String protectedSectionClient = reader.getProtectedRegionContent(fileContent, ProtectedRegionIdentifier.CLIENT_REGION);
        context.setProtectedDataTypeRegion(protectedSectionDataTypes);
        context.setProtectedEndpointRegion(protectedSectionEndpoints);
        context.setProtectedProviderRegion(protectedSectionProviders);
        context.setProtectedClientRegion(protectedSectionClient);
        if (protectedSectionDataTypes != null) {
            context.addDataTypeIdentifiers(reader.getIdentifiersInProtectedRegion(protectedSectionDataTypes, ProtectedRegionIdentifier.DATA_TYPE_REGION));
        }
        if (protectedSectionEndpoints != null) {
            context.addEndpointIdentifiers(reader.getIdentifiersInProtectedRegion(protectedSectionEndpoints, ProtectedRegionIdentifier.ENDPOINT_REGION));
        }
        if (protectedSectionProviders != null) {
            context.addProviderIdentifiers(reader.getIdentifiersInProtectedRegion(protectedSectionProviders, ProtectedRegionIdentifier.PROVIDER_REGION));
        }
        if (protectedSectionClient != null) {
            context.addClientIdentifiers(reader.getIdentifiersInProtectedRegion(protectedSectionClient, ProtectedRegionIdentifier.CLIENT_REGION));
        }
        return context;
    }
}

