/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml.value_impact_mapping;

import java.util.List;
import org.contextmapper.dsl.contextMappingDSL.Consequence;
import org.contextmapper.dsl.contextMappingDSL.ValueCluster;
import org.contextmapper.dsl.contextMappingDSL.ValueElicitation;
import org.contextmapper.dsl.contextMappingDSL.ValueRegister;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.ConsequenceOnValue;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.MitigationAction;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.Stakeholder;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.SystemOfInterest;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.Value;

public class CML2ValueImpactModelMapper {
    private static final String DEFAULT_SOI_NAME = "System of Interest (SOI)";
    private SystemOfInterest soi;

    public SystemOfInterest map(ValueRegister valueRegister) {
        this.soi = new SystemOfInterest(valueRegister.getContext() != null ? valueRegister.getContext().getName() : DEFAULT_SOI_NAME);
        if (valueRegister.getValueClusters().isEmpty() && valueRegister.getValues().isEmpty()) {
            return this.soi;
        }
        for (ValueCluster valueCluster : valueRegister.getValueClusters()) {
            this.mapValueCluster(valueCluster);
        }
        for (org.contextmapper.dsl.contextMappingDSL.Value value : valueRegister.getValues()) {
            this.mapValue(value);
        }
        return this.soi;
    }

    private void mapValueCluster(ValueCluster cluster) {
        for (ValueElicitation elicitation : cluster.getElicitations()) {
            this.mapStakeholderElicitedValue(cluster.getCoreValue7000() != null ? cluster.getCoreValue7000().toString() : cluster.getCoreValue(), (List<String>)cluster.getDemonstrators(), elicitation);
        }
        for (org.contextmapper.dsl.contextMappingDSL.Value value : cluster.getValues()) {
            this.mapValue(value);
        }
    }

    private void mapValue(org.contextmapper.dsl.contextMappingDSL.Value value) {
        for (ValueElicitation elicitation : value.getElicitations()) {
            this.mapStakeholderElicitedValue(value.getName(), (List<String>)value.getDemonstrators(), elicitation);
        }
    }

    private void mapStakeholderElicitedValue(String valueName, List<String> demonstrators, ValueElicitation elicitation) {
        String stakeholderDescription = elicitation.getStakeholder() instanceof org.contextmapper.dsl.contextMappingDSL.Stakeholder ? ((org.contextmapper.dsl.contextMappingDSL.Stakeholder)elicitation.getStakeholder()).getDescription() : null;
        Stakeholder stakeholder = this.soi.getOrCreateStakeholder(elicitation.getStakeholder().getName(), stakeholderDescription);
        if (elicitation.getConsequences().isEmpty()) {
            Value value = this.createValueObject(valueName, demonstrators, elicitation);
            value.setConsequenceType(ConsequenceOnValue.NEUTRAL);
            stakeholder.addValue(value);
        }
        for (Consequence consequence : elicitation.getConsequences()) {
            Value value = this.createValueObject(valueName, demonstrators, elicitation);
            value.setConsequenceType(ConsequenceOnValue.valueOfLowerCase(consequence.getType()));
            if (consequence.getConsequence() != null && !"".equals(consequence.getConsequence())) {
                value.setConsequence(consequence.getConsequence());
            }
            if (consequence.getAction() != null) {
                value.addMitigationAction(new MitigationAction(consequence.getAction().getType(), consequence.getAction().getAction()));
            }
            stakeholder.addValue(value);
        }
    }

    private Value createValueObject(String valueName, List<String> demonstrators, ValueElicitation elicitation) {
        Value value = new Value(valueName);
        value.setPriority(elicitation.getPriority());
        value.setImpact(elicitation.getImpact());
        value.addDemonstrators(demonstrators);
        return value;
    }
}

