/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring.stakeholders;

import org.contextmapper.dsl.contextMappingDSL.Consequence;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.IMPACT;
import org.contextmapper.dsl.contextMappingDSL.PRIORITY;
import org.contextmapper.dsl.contextMappingDSL.Stakeholder;
import org.contextmapper.dsl.contextMappingDSL.Value;
import org.contextmapper.dsl.contextMappingDSL.ValueElicitation;
import org.contextmapper.dsl.contextMappingDSL.ValueRegister;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class CreateValue4StakeholderRefactoring
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String stakeholderName;

    public CreateValue4StakeholderRefactoring(String stakeholderName) {
        this.stakeholderName = stakeholderName;
    }

    @Override
    protected void doRefactor() {
        Stakeholder s = this.getSelectedStakeholder();
        ValueRegister valueRegister = this.getOrCreateValueRegister();
        Value value = ContextMappingDSLFactory.eINSTANCE.createValue();
        value.setName("To_Be_Defined");
        value.getDemonstrators().add((Object)"Example where and how this value can be observed.");
        ValueElicitation elicitation = ContextMappingDSLFactory.eINSTANCE.createValueElicitation();
        elicitation.setStakeholder(s);
        elicitation.setImpact(IMPACT.MEDIUM);
        elicitation.setPriority(PRIORITY.MEDIUM);
        Consequence consequence = ContextMappingDSLFactory.eINSTANCE.createConsequence();
        consequence.setConsequence("Sample consequence for/of [value] for [stakeholder], can be good, bad or neutral.");
        consequence.setType("neutral");
        elicitation.getConsequences().add((Object)consequence);
        value.getElicitations().add((Object)elicitation);
        valueRegister.getValues().add((Object)value);
    }

    private Stakeholder getSelectedStakeholder() {
        return EcoreUtil2.getAllContentsOfType((EObject)this.model, Stakeholder.class).stream().filter(s -> s.getName().equals(this.stakeholderName)).findFirst().get();
    }

    private ValueRegister getOrCreateValueRegister() {
        if (this.model.getValueRegisters().isEmpty()) {
            ValueRegister valueRegister = ContextMappingDSLFactory.eINSTANCE.createValueRegister();
            valueRegister.setName("Register_Name_To_Be_Changed");
            this.model.getValueRegisters().add((Object)valueRegister);
            return valueRegister;
        }
        return (ValueRegister)this.model.getValueRegisters().get(0);
    }
}

