/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring.stakeholders;

import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.Stakeholder;
import org.contextmapper.dsl.contextMappingDSL.StakeholderGroup;
import org.contextmapper.dsl.contextMappingDSL.Stakeholders;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class MoveStakeholderToNewStakeholderGroupRefactoring
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String stakeholderName;

    public MoveStakeholderToNewStakeholderGroupRefactoring(String stakeholderName) {
        this.stakeholderName = stakeholderName;
    }

    @Override
    protected void doRefactor() {
        Stakeholder s = this.getSelectedStakeholder();
        Stakeholders container = this.getContainerAndRemoveStakeholder(s);
        if (container != null) {
            StakeholderGroup newGroup = ContextMappingDSLFactory.eINSTANCE.createStakeholderGroup();
            newGroup.setName("Groupname_To_Be_Changed");
            container.getStakeholders().add((Object)newGroup);
            newGroup.getStakeholders().add((Object)s);
        }
    }

    private Stakeholder getSelectedStakeholder() {
        return EcoreUtil2.getAllContentsOfType((EObject)this.model, Stakeholder.class).stream().filter(s -> s.getName().equals(this.stakeholderName)).findFirst().get();
    }

    private Stakeholders getContainerAndRemoveStakeholder(Stakeholder s) {
        if (s.eContainer() instanceof Stakeholders) {
            Stakeholders container = (Stakeholders)s.eContainer();
            container.getStakeholders().remove((Object)s);
            return container;
        }
        if (s.eContainer() instanceof StakeholderGroup) {
            StakeholderGroup group = (StakeholderGroup)s.eContainer();
            group.getStakeholders().remove((Object)s);
            if (group.eContainer() instanceof Stakeholders) {
                return (Stakeholders)group.eContainer();
            }
        }
        return null;
    }
}

