/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.BoundedContextType;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class TeamSemanticsValidator
extends AbstractDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void onlyTeamsCanRealizeBoundedContexts(BoundedContext boundedContext) {
        if (!boundedContext.getRealizedBoundedContexts().isEmpty() && !BoundedContextType.TEAM.equals((Object)boundedContext.getType())) {
            this.error(String.format("Only teams can realize bounded contexts. '%s' is not a team!", boundedContext.getName()), boundedContext, (EStructuralFeature)ContextMappingDSLPackage.Literals.BOUNDED_CONTEXT__REALIZED_BOUNDED_CONTEXTS);
        }
    }

    @Check
    public void checkThatAggregateOwnersAreTeams(Aggregate aggregate) {
        if (aggregate.getOwner() == null) {
            return;
        }
        BoundedContext owner = aggregate.getOwner();
        if (owner.getType() == null || !BoundedContextType.TEAM.equals((Object)owner.getType())) {
            this.error(String.format("'%s' is not a team. The owner attribute must refer to a Bounded Context representing a team (type = TEAM)!", owner.getName()), aggregate, (EStructuralFeature)ContextMappingDSLPackage.Literals.AGGREGATE__OWNER);
        }
    }
}

