/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.UserStory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class UserRequirementsValidator
extends AbstractDeclarativeValidator {
    public static final String ID_SPLIT_FEATURE_BY_VERB_SUGGESTION = "split-feature-by-verb-suggestion";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void validateFeature(Feature feature) {
        if (feature.getEntity() == null) {
            return;
        }
        if (!feature.getEntity().matches("^[a-zA-Z_][a-zA-Z0-9_]*")) {
            this.warning("The entity name should consist of the following characters: a-z, A-Z, 0-9, _. Please rename the entity accordingly before applying transformations.", feature, (EStructuralFeature)ContextMappingDSLPackage.Literals.FEATURE__ENTITY);
        }
        if (feature.getVerb() == null) {
            return;
        }
        if (!feature.getVerb().matches("^[a-zA-Z_][a-zA-Z0-9_]*")) {
            this.warning("The verb should consist of the following characters: a-z, A-Z, 0-9, _. Please rename it accordingly before applying transformations.", feature, (EStructuralFeature)ContextMappingDSLPackage.Literals.FEATURE__VERB);
        }
    }

    @Check
    public void provideStorySplittingSuggestion(Feature feature) {
        UserStory story;
        if (feature.getVerb() == null || "".equals(feature.getVerb())) {
            return;
        }
        if (feature.eContainer() instanceof UserStory && (story = (UserStory)feature.eContainer()).getSplittingStory() == null && story.getFeatures().size() == 1) {
            this.info("You could split your story by its operation/verb.", feature, (EStructuralFeature)ContextMappingDSLPackage.Literals.FEATURE__VERB, ID_SPLIT_FEATURE_BY_VERB_SUGGESTION, new String[0]);
        }
    }
}

