/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.tactic.dsl.tacticdsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CollectionType implements Enumerator
{
    NONE(0, "None", "None"),
    SET(1, "Set", "Set"),
    LIST(2, "List", "List"),
    BAG(3, "Bag", "Bag"),
    COLLECTION(4, "Collection", "Collection");

    public static final int NONE_VALUE = 0;
    public static final int SET_VALUE = 1;
    public static final int LIST_VALUE = 2;
    public static final int BAG_VALUE = 3;
    public static final int COLLECTION_VALUE = 4;
    private static final CollectionType[] VALUES_ARRAY;
    public static final List<CollectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CollectionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CollectionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CollectionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CollectionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CollectionType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return SET;
            }
            case 2: {
                return LIST;
            }
            case 3: {
                return BAG;
            }
            case 4: {
                return COLLECTION;
            }
        }
        return null;
    }

    private CollectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CollectionType[]{NONE, SET, LIST, BAG, COLLECTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

