/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.config;

import ch.hsr.servicecutter.api.SolverConfigurationFactory;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.contextmapper.dsl.config.ServiceCutterConfig;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Tag;

public class ServiceCutterConfigHandler {
    private File projectRoot;
    private static final String SC_CONFIG_FILENAME = ".servicecutter.yml";

    public ServiceCutterConfigHandler(File projectRoot) {
        if (!projectRoot.exists()) {
            throw new ContextMapperApplicationException("The project directory '" + projectRoot.getAbsolutePath() + "' does not exist!");
        }
        this.projectRoot = projectRoot;
    }

    public ServiceCutterConfig createAndGetServiceCutterConfig() {
        this.createConfigFile();
        File configFile = new File(this.projectRoot, SC_CONFIG_FILENAME);
        Yaml yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(this.getClass().getClassLoader()));
        try {
            FileInputStream inputStream = new FileInputStream(configFile);
            return (ServiceCutterConfig)yaml.loadAs((InputStream)inputStream, ServiceCutterConfig.class);
        }
        catch (FileNotFoundException e) {
            throw new ContextMapperApplicationException("Could not read '.servicecutter.yml' file!", e);
        }
        catch (YAMLException e) {
            throw new ContextMapperApplicationException("Could not parse '.servicecutter.yml' file. Allowed values for criteria priorities are: IGNORE, XS, S, M, L, XL, and XXL.", e);
        }
    }

    public SolverConfiguration getServiceCutterSolverConfiguration() {
        ServiceCutterConfig config = this.createAndGetServiceCutterConfig();
        SolverConfiguration solverConfig = new SolverConfiguration();
        solverConfig.setAlgorithm(config.getAlgorithm());
        solverConfig.getAlgorithmParams().putAll(config.getAlgorithmParams());
        solverConfig.getPriorities().putAll(config.getPriorities());
        return solverConfig;
    }

    private void createConfigFile() {
        File configFile = new File(this.projectRoot, SC_CONFIG_FILENAME);
        if (configFile.exists()) {
            return;
        }
        ServiceCutterConfig config = this.createInitialServiceCutterConfig();
        try {
            FileWriter writer = new FileWriter(configFile);
            writer.write(new Yaml().dumpAs((Object)config, Tag.MAP, DumperOptions.FlowStyle.BLOCK));
            writer.close();
        }
        catch (IOException e) {
            throw new ContextMapperApplicationException("Could not create '.servicecutter.yml' file!", e);
        }
    }

    private ServiceCutterConfig createInitialServiceCutterConfig() {
        ServiceCutterConfig config = new ServiceCutterConfig();
        SolverConfiguration defaultSolverConfig = new SolverConfigurationFactory().createDefaultConfiguration();
        config.setAlgorithm(defaultSolverConfig.getAlgorithm());
        config.setAlgorithmParams(defaultSolverConfig.getAlgorithmParams());
        config.setPriorities(defaultSolverConfig.getPriorities());
        return config;
    }
}

