/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Similarity implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    NORMAL(1, "NORMAL", "NORMAL"),
    HUGE(2, "HUGE", "HUGE"),
    TINY(3, "TINY", "TINY");

    public static final int UNDEFINED_VALUE = 0;
    public static final int NORMAL_VALUE = 1;
    public static final int HUGE_VALUE = 2;
    public static final int TINY_VALUE = 3;
    private static final Similarity[] VALUES_ARRAY;
    public static final List<Similarity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Similarity get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Similarity result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Similarity getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Similarity result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Similarity get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return NORMAL;
            }
            case 2: {
                return HUGE;
            }
            case 3: {
                return TINY;
            }
        }
        return null;
    }

    private Similarity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Similarity[]{UNDEFINED, NORMAL, HUGE, TINY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

