/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Flow;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.generator.AbstractContextMappingModelGenerator;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.generator.plantuml.PlantUMLAggregateClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLBoundedContextClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLComponentDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLModuleClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLStateDiagramCreator4Aggregate;
import org.contextmapper.dsl.generator.plantuml.PlantUMLStateDiagramCreator4Flow;
import org.contextmapper.dsl.generator.plantuml.PlantUMLSubdomainClassDiagramCreator;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.StateTransition;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class PlantUMLGenerator
extends AbstractContextMappingModelGenerator {
    private static final String PLANT_UML_FILE_EXT = "puml";

    @Override
    protected void generateFromContextMappingModel(ContextMappingModel model, IFileSystemAccess2 fsa, URI inputFileURI) {
        this.checkPreconditions();
        String fileName = inputFileURI.trimFileExtension().lastSegment();
        if (model.getMap() != null) {
            fsa.generateFile(fileName + "_ContextMap.puml", (CharSequence)new PlantUMLComponentDiagramCreator().createDiagram(model.getMap()));
        }
        for (BoundedContext boundedContext : model.getBoundedContexts()) {
            fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + ".puml", (CharSequence)new PlantUMLBoundedContextClassDiagramCreator().createDiagram(boundedContext));
            for (Aggregate aggregate : boundedContext.getAggregates()) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + aggregate.getName() + ".puml", (CharSequence)new PlantUMLAggregateClassDiagramCreator().createDiagram(aggregate));
            }
            for (SculptorModule module : boundedContext.getModules()) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + module.getName() + ".puml", (CharSequence)new PlantUMLModuleClassDiagramCreator().createDiagram(module));
            }
            List<Aggregate> aggregatesWithStates = this.getAggregatesWithStatesAndTransitions(boundedContext);
            for (Aggregate aggregate : aggregatesWithStates) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + aggregate.getName() + "_StateDiagram.puml", (CharSequence)new PlantUMLStateDiagramCreator4Aggregate().createDiagram(aggregate));
            }
            for (Flow flow : this.getFlowsWithStates(boundedContext)) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + flow.getName() + "_StateDiagram.puml", (CharSequence)new PlantUMLStateDiagramCreator4Flow().createDiagram(flow));
            }
        }
        for (Domain domain : model.getDomains()) {
            domain.getSubdomains().stream().filter(subdomain -> !subdomain.getEntities().isEmpty()).forEach(subdomain -> fsa.generateFile(fileName + "_SD_" + subdomain.getName() + ".puml", (CharSequence)new PlantUMLSubdomainClassDiagramCreator(domain.getName()).createDiagram(subdomain)));
        }
    }

    private void checkPreconditions() {
        if (this.contextMappingModel.getMap() == null && this.contextMappingModel.getBoundedContexts().isEmpty() && !this.modelHasSubdomainWithEntities()) {
            throw new GeneratorInputException("Your model does not contain a Context Map, a Bounded Context, or a Subdomain. Therefore we have nothing to generate. Create at least one of the mentioned Objects.");
        }
    }

    private List<Flow> getFlowsWithStates(BoundedContext bc) {
        LinkedList flows = Lists.newLinkedList();
        if (bc.getApplication() != null) {
            for (Flow flow : bc.getApplication().getFlows()) {
                if (EcoreUtil2.eAllOfType((EObject)flow, StateTransition.class).isEmpty()) continue;
                flows.add(flow);
            }
        }
        return flows;
    }

    private List<Aggregate> getAggregatesWithStatesAndTransitions(BoundedContext bc) {
        LinkedList aggregates = Lists.newLinkedList();
        for (Aggregate aggregate : EcoreUtil2.eAllOfType((EObject)bc, Aggregate.class)) {
            List stateTransitions;
            Optional<Enum> statesEnum = EcoreUtil2.eAllOfType((EObject)aggregate, Enum.class).stream().filter(e -> e.isDefinesAggregateLifecycle()).findFirst();
            if (!statesEnum.isPresent() || (stateTransitions = EcoreUtil2.eAllOfType((EObject)aggregate, StateTransition.class)).isEmpty()) continue;
            aggregates.add(aggregate);
        }
        return aggregates;
    }

    private boolean modelHasSubdomainWithEntities() {
        for (Domain domain : this.contextMappingModel.getDomains()) {
            Optional<Subdomain> optSubdomain = domain.getSubdomains().stream().filter(subdomain -> !subdomain.getEntities().isEmpty()).findAny();
            if (!optSubdomain.isPresent()) continue;
            return true;
        }
        return false;
    }
}

