/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.input.converter;

import ch.hsr.servicecutter.api.model.Characteristic;
import ch.hsr.servicecutter.api.model.UseCase;
import ch.hsr.servicecutter.api.model.UserRepresentationContainer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Compatibilities;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.RelatedGroup;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterUserRepresentationsModel;

public class SCLToUserRepresentationsConverter {
    public UserRepresentationContainer convert(ServiceCutterUserRepresentationsModel sclUserRepresentationsModel) {
        UserRepresentationContainer container = new UserRepresentationContainer();
        if (sclUserRepresentationsModel.getCompatibilities() != null) {
            container.setCompatibilities(this.convert(sclUserRepresentationsModel.getCompatibilities()));
        }
        container.setUseCases(this.convertUseCases((List<org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.UseCase>)sclUserRepresentationsModel.getUseCases()));
        container.setAggregates(this.convertRelatedGroups((List<? extends RelatedGroup>)sclUserRepresentationsModel.getAggregates()));
        container.setEntities(this.convertRelatedGroups((List<? extends RelatedGroup>)sclUserRepresentationsModel.getEntities()));
        container.setPredefinedServices(this.convertRelatedGroups((List<? extends RelatedGroup>)sclUserRepresentationsModel.getPredefinedServices()));
        container.setSecurityAccessGroups(this.convertRelatedGroups((List<? extends RelatedGroup>)sclUserRepresentationsModel.getSecurityAccessGroups()));
        container.setSeparatedSecurityZones(this.convertRelatedGroups((List<? extends RelatedGroup>)sclUserRepresentationsModel.getSeparatedSecurityZones()));
        container.setSharedOwnerGroups(this.convertRelatedGroups((List<? extends RelatedGroup>)sclUserRepresentationsModel.getSharedOwnerGroups()));
        return container;
    }

    private ch.hsr.servicecutter.api.model.Compatibilities convert(Compatibilities sclCompatibilities) {
        ch.hsr.servicecutter.api.model.Compatibilities compatibilities = new ch.hsr.servicecutter.api.model.Compatibilities();
        compatibilities.setAvailabilityCriticality(this.convertCharacteristics((List<? extends org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic>)sclCompatibilities.getAvailabilityCriticality()));
        compatibilities.setConsistencyCriticality(this.convertCharacteristics((List<? extends org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic>)sclCompatibilities.getConsistencyCriticality()));
        compatibilities.setContentVolatility(this.convertCharacteristics((List<? extends org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic>)sclCompatibilities.getContentVolatility()));
        compatibilities.setSecurityCriticality(this.convertCharacteristics((List<? extends org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic>)sclCompatibilities.getSecurityCriticality()));
        compatibilities.setStorageSimilarity(this.convertCharacteristics((List<? extends org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic>)sclCompatibilities.getStorageSimilarity()));
        compatibilities.setStructuralVolatility(this.convertCharacteristics((List<? extends org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic>)sclCompatibilities.getStructuralVolatility()));
        return compatibilities;
    }

    private List<Characteristic> convertCharacteristics(List<? extends org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic> sclCharacteristics) {
        ArrayList characteristics = Lists.newArrayList();
        for (org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic characteristic : sclCharacteristics) {
            characteristics.add(this.convert(characteristic));
        }
        return characteristics;
    }

    private Characteristic convert(org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic sclCharacteristic) {
        Characteristic characteristic = new Characteristic();
        characteristic.setCharacteristic(sclCharacteristic.getCharacteristic());
        characteristic.setNanoentities((List)Lists.newArrayList(sclCharacteristic.getNanoentities()));
        return characteristic;
    }

    private List<UseCase> convertUseCases(List<org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.UseCase> sclUseCases) {
        ArrayList useCases = Lists.newArrayList();
        for (org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.UseCase useCase : sclUseCases) {
            useCases.add(this.convert(useCase));
        }
        return useCases;
    }

    private UseCase convert(org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.UseCase sclUseCase) {
        UseCase useCase = new UseCase();
        useCase.setName(sclUseCase.getName());
        useCase.setLatencyCritical(sclUseCase.isIsLatencyCritical());
        useCase.setNanoentitiesRead((List)Lists.newArrayList(sclUseCase.getNanoentitiesRead()));
        useCase.setNanoentitiesWritten((List)Lists.newArrayList(sclUseCase.getNanoentitiesWritten()));
        return useCase;
    }

    private List<ch.hsr.servicecutter.api.model.RelatedGroup> convertRelatedGroups(List<? extends RelatedGroup> sclRelatedGroups) {
        ArrayList relatedGroups = Lists.newArrayList();
        for (RelatedGroup relatedGroup : sclRelatedGroups) {
            relatedGroups.add(this.convert(relatedGroup));
        }
        return relatedGroups;
    }

    private ch.hsr.servicecutter.api.model.RelatedGroup convert(RelatedGroup sclRelatedGroup) {
        ch.hsr.servicecutter.api.model.RelatedGroup relatedGroup = new ch.hsr.servicecutter.api.model.RelatedGroup();
        relatedGroup.setName(sclRelatedGroup.getName());
        relatedGroup.setNanoentities((List)Lists.newArrayList(sclRelatedGroup.getNanoentities()));
        return relatedGroup;
    }
}

