/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import java.util.List;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.dsl.refactoring.exception.RefactoringInputException;

public abstract class AbstractToggleSymmetricRelationshipRefactoring
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    protected String boundedContext1;
    protected String boundedContext2;

    public AbstractToggleSymmetricRelationshipRefactoring(String boundedContext1, String boundedContext2) {
        this.boundedContext1 = boundedContext1;
        this.boundedContext2 = boundedContext2;
    }

    @Override
    protected void doRefactor() {
        this.checkPreconditions();
        ContextMap contextMap = this.model.getMap();
        SymmetricRelationship originalRelationship = this.getMatchingRelationship();
        SymmetricRelationship newRelationship = "SharedKernel".equals(this.getRelationshipType()) ? ContextMappingDSLFactory.eINSTANCE.createPartnership() : ContextMappingDSLFactory.eINSTANCE.createSharedKernel();
        newRelationship.setImplementationTechnology(originalRelationship.getImplementationTechnology());
        newRelationship.setName(originalRelationship.getName());
        newRelationship.setParticipant1(originalRelationship.getParticipant1());
        newRelationship.setParticipant2(originalRelationship.getParticipant2());
        this.removeElementFromEList(contextMap.getRelationships(), originalRelationship);
        this.addElementToEList(contextMap.getRelationships(), newRelationship);
    }

    abstract String getRelationshipType();

    abstract List<SymmetricRelationship> getMatchingRelationships();

    private void checkPreconditions() {
        if (this.boundedContext1 == null || this.boundedContext2 == null) {
            throw new RefactoringInputException("Please provide two bounded context names (input parameter was null).");
        }
        if (this.boundedContext1.equals(this.boundedContext2)) {
            throw new RefactoringInputException("Please provide two different bounded context names (input parameters contain same name).");
        }
        List<SymmetricRelationship> matchingRelationships = this.getMatchingRelationships();
        if (matchingRelationships.size() > 1) {
            throw new RefactoringInputException("There are multiple " + this.getRelationshipType() + " relationships between '" + this.boundedContext1 + "' and '" + this.boundedContext2 + "'.");
        }
        if (matchingRelationships.isEmpty()) {
            throw new RefactoringInputException("Your Context Map does not contain a " + this.getRelationshipType() + " relationship between '" + this.boundedContext1 + "' and '" + this.boundedContext2 + "'.");
        }
    }

    private SymmetricRelationship getMatchingRelationship() {
        return this.getMatchingRelationships().get(0);
    }
}

