/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum KnowledgeLevel implements Enumerator
{
    META(0, "META", "META"),
    CONCRETE(1, "CONCRETE", "CONCRETE");

    public static final int META_VALUE = 0;
    public static final int CONCRETE_VALUE = 1;
    private static final KnowledgeLevel[] VALUES_ARRAY;
    public static final List<KnowledgeLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static KnowledgeLevel get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            KnowledgeLevel result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static KnowledgeLevel getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            KnowledgeLevel result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static KnowledgeLevel get(int value) {
        switch (value) {
            case 0: {
                return META;
            }
            case 1: {
                return CONCRETE;
            }
        }
        return null;
    }

    private KnowledgeLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new KnowledgeLevel[]{META, CONCRETE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

