/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.exception;

import java.util.Set;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;

public class RefactoringSerializationException
extends ContextMapperApplicationException {
    public RefactoringSerializationException(Set<String> errorMessages) {
        super(RefactoringSerializationException.getErrorMessage(errorMessages));
    }

    private static String getErrorMessage(Set<String> errorMessages) {
        String message = "This refactoring cannot be applied given your input model and parameters. It leads to the following errors:" + System.lineSeparator() + System.lineSeparator();
        for (String errorMessage : errorMessages) {
            message = message + RefactoringSerializationException.mapErrorMessage(errorMessage) + System.lineSeparator();
        }
        return message;
    }

    private static String mapErrorMessage(String errorMessage) {
        if (errorMessage.startsWith("No EObjectDescription could be found in Scope") && errorMessage.contains("EStructuralFeature: tacticdsl::Reference.domainObjectType")) {
            return RefactoringSerializationException.handleNoEObjectDescriptionError(errorMessage);
        }
        return errorMessage;
    }

    private static String handleNoEObjectDescriptionError(String errorMessage) {
        return "The refactoring creates a new domain object with a name that already exists. As the name is referenced from another domain object, serialization is not possible as it leads to an ambiguous reference. " + System.lineSeparator() + System.lineSeparator() + "(" + errorMessage + ")";
    }
}

