/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.UseCase;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLDiagramCreator;

public class PlantUMLUseCaseInteractionsSequenceDiagramCreator
extends AbstractPlantUMLDiagramCreator<UseCase>
implements PlantUMLDiagramCreator<UseCase> {
    private UseCase useCase;
    private static final String SYSTEM_NAME = "System";

    @Override
    protected void printDiagramContent(UseCase useCase) {
        this.useCase = useCase;
        this.printStartOfGroup();
        this.printPrimaryActorUsingSystem();
        this.printInteractions();
        this.printSecondaryActorsTriggeredBySystem();
        this.printEndOfGroup();
        this.printUseCaseBenefit();
        this.printDisclaimerNote();
    }

    private void printStartOfGroup() {
        this.sb.append("group ").append("Use Case ").append(this.useCase.getName());
        this.linebreak();
    }

    private void printEndOfGroup() {
        this.sb.append("end");
        this.linebreak();
    }

    private void printPrimaryActorUsingSystem() {
        if (this.useCase.getRole() != null && !"".equals(this.useCase.getRole())) {
            Feature firstFeature = (Feature)this.useCase.getFeatures().get(0);
            this.sb.append("\"" + this.useCase.getRole() + "\"").append(" -> ").append(SYSTEM_NAME).append(" : ").append(firstFeature.getVerb()).append(" ").append(firstFeature.getEntity());
            this.linebreak();
        }
        this.linebreak();
    }

    private void printInteractions() {
        int initialInteraction;
        for (int i = initialInteraction = this.useCase.getRole() != null && !"".equals(this.useCase.getRole()) ? 1 : 0; i < this.useCase.getFeatures().size(); ++i) {
            Feature feature = (Feature)this.useCase.getFeatures().get(i);
            this.sb.append(SYSTEM_NAME).append(" -> ").append(SYSTEM_NAME).append(" : ").append(feature.getVerb()).append(" ").append(feature.getEntity());
            this.linebreak();
        }
        this.linebreak();
    }

    private void printSecondaryActorsTriggeredBySystem() {
        if (!this.useCase.getSecondaryActors().isEmpty()) {
            for (String secondaryActor : this.useCase.getSecondaryActors()) {
                this.sb.append(SYSTEM_NAME).append(" -> ").append("\"" + secondaryActor + "\"");
                this.linebreak();
            }
        }
        this.linebreak();
    }

    private void printUseCaseBenefit() {
        if (this.useCase.getBenefit() != null && !"".equals(this.useCase.getBenefit())) {
            this.sb.append("note over System : ").append(this.useCase.getBenefit());
            this.linebreak();
        }
        this.linebreak();
    }

    private void printDisclaimerNote() {
        this.sb.append("note right").append(System.lineSeparator()).append("  Note: This diagram only illustrates the interactions of the").append(System.lineSeparator()).append("  use case in an early analysis state, as modelled in CML.").append(System.lineSeparator()).append("  Hence, some interactions might not be triggered/connected").append(System.lineSeparator()).append("  by the correct actor(s) (known limitation).").append(System.lineSeparator());
        this.sb.append("end note").append(System.lineSeparator());
        this.linebreak();
    }
}

