/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.input.nanoentities;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;

public class NanoentityResolver {
    public Set<String> getAllNanoentities(BoundedContext bc) {
        HashSet nanoentities = Sets.newHashSet();
        for (Aggregate aggregate : bc.getAggregates()) {
            nanoentities.addAll(this.getAllNanoentities(aggregate));
        }
        return nanoentities;
    }

    public Set<String> getAllNanoentities(Aggregate aggregate) {
        HashSet nanoentities = Sets.newHashSet();
        for (DomainObject domainObject : aggregate.getDomainObjects().stream().filter(o -> o instanceof DomainObject).map(o -> (DomainObject)o).collect(Collectors.toSet())) {
            nanoentities.addAll(this.getAllNanoentities(domainObject));
        }
        return nanoentities;
    }

    public Set<String> getAllNanoentities(DomainObject domainObject) {
        HashSet nanoentities = Sets.newHashSet();
        for (Attribute attr : domainObject.getAttributes()) {
            nanoentities.add(domainObject.getName() + "." + attr.getName());
        }
        for (Reference reference : domainObject.getReferences()) {
            nanoentities.add(domainObject.getName() + "." + reference.getName());
        }
        return nanoentities;
    }
}

