/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.input.userrepresentations;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Criticality;
import org.contextmapper.dsl.contextMappingDSL.Similarity;
import org.contextmapper.dsl.contextMappingDSL.Volatility;
import org.contextmapper.dsl.generator.servicecutter.input.nanoentities.NanoentityResolver;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.AvailabilityCriticality;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Compatibilities;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ConsistencyCriticality;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ContentVolatility;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.SecurityCriticality;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterConfigurationDSLFactory;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.StorageSimilarity;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.StructuralVolatility;

public class CompatibilityBuilder {
    private CMLModelObjectsResolvingHelper resolvingHelper;
    private NanoentityResolver nanoentityResolver;

    public CompatibilityBuilder(ContextMappingModel cmlModel) {
        this.resolvingHelper = new CMLModelObjectsResolvingHelper(cmlModel);
        this.nanoentityResolver = new NanoentityResolver();
    }

    public Compatibilities buildCompatibilities() {
        Compatibilities compatibilities = ServiceCutterConfigurationDSLFactory.eINSTANCE.createCompatibilities();
        this.buildStructuralVolatilitySets(compatibilities);
        this.buildContentVolatilitySets(compatibilities);
        this.buildAvailabilityCriticalitySets(compatibilities);
        this.buildConsistencyCriticalitySets(compatibilities);
        this.buildStorageSimilaritySets(compatibilities);
        this.buildSecurityCriticalitySets(compatibilities);
        return compatibilities;
    }

    private void buildStructuralVolatilitySets(Compatibilities compatibilities) {
        compatibilities.getStructuralVolatility().clear();
        Set<String> normalNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getLikelihoodForChange() == Volatility.NORMAL);
        Set<String> oftenNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getLikelihoodForChange() == Volatility.OFTEN);
        Set<String> rarelyNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getLikelihoodForChange() == Volatility.RARELY);
        if (!normalNanoEntities.isEmpty()) {
            compatibilities.getStructuralVolatility().add((Object)this.createStructuralVolatility("Normal", normalNanoEntities));
        }
        if (!oftenNanoEntities.isEmpty()) {
            compatibilities.getStructuralVolatility().add((Object)this.createStructuralVolatility("Often", oftenNanoEntities));
        }
        if (!rarelyNanoEntities.isEmpty()) {
            compatibilities.getStructuralVolatility().add((Object)this.createStructuralVolatility("Rarely", rarelyNanoEntities));
        }
    }

    private void buildContentVolatilitySets(Compatibilities compatibilities) {
        compatibilities.getContentVolatility().clear();
        Set<String> normalNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getContentVolatility() == Volatility.NORMAL);
        Set<String> oftenNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getContentVolatility() == Volatility.OFTEN);
        Set<String> rarelyNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getContentVolatility() == Volatility.RARELY);
        if (!normalNanoEntities.isEmpty()) {
            compatibilities.getContentVolatility().add((Object)this.createContentVolatility("Regularly", normalNanoEntities));
        }
        if (!oftenNanoEntities.isEmpty()) {
            compatibilities.getContentVolatility().add((Object)this.createContentVolatility("Often", oftenNanoEntities));
        }
        if (!rarelyNanoEntities.isEmpty()) {
            compatibilities.getContentVolatility().add((Object)this.createContentVolatility("Rarely", rarelyNanoEntities));
        }
    }

    private void buildAvailabilityCriticalitySets(Compatibilities compatibilities) {
        compatibilities.getAvailabilityCriticality().clear();
        Set<String> normalNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getAvailabilityCriticality() == Criticality.NORMAL);
        Set<String> highNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getAvailabilityCriticality() == Criticality.HIGH);
        Set<String> lowNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getAvailabilityCriticality() == Criticality.LOW);
        if (!normalNanoEntities.isEmpty()) {
            compatibilities.getAvailabilityCriticality().add((Object)this.createAvailabilityCriticality("Normal", normalNanoEntities));
        }
        if (!highNanoEntities.isEmpty()) {
            compatibilities.getAvailabilityCriticality().add((Object)this.createAvailabilityCriticality("Critical", highNanoEntities));
        }
        if (!lowNanoEntities.isEmpty()) {
            compatibilities.getAvailabilityCriticality().add((Object)this.createAvailabilityCriticality("Low", lowNanoEntities));
        }
    }

    private void buildConsistencyCriticalitySets(Compatibilities compatibilities) {
        compatibilities.getConsistencyCriticality().clear();
        Set<String> normalNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getConsistencyCriticality() == Criticality.NORMAL);
        Set<String> highNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getConsistencyCriticality() == Criticality.HIGH);
        Set<String> lowNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getConsistencyCriticality() == Criticality.LOW);
        if (!normalNanoEntities.isEmpty()) {
            compatibilities.getConsistencyCriticality().add((Object)this.createConsistencyCriticality("Eventually", normalNanoEntities));
        }
        if (!highNanoEntities.isEmpty()) {
            compatibilities.getConsistencyCriticality().add((Object)this.createConsistencyCriticality("High", highNanoEntities));
        }
        if (!lowNanoEntities.isEmpty()) {
            compatibilities.getConsistencyCriticality().add((Object)this.createConsistencyCriticality("Weak", lowNanoEntities));
        }
    }

    private void buildStorageSimilaritySets(Compatibilities compatibilities) {
        compatibilities.getStorageSimilarity().clear();
        Set<String> normalNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getStorageSimilarity() == Similarity.NORMAL);
        Set<String> highNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getStorageSimilarity() == Similarity.HUGE);
        Set<String> lowNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getStorageSimilarity() == Similarity.TINY);
        if (!normalNanoEntities.isEmpty()) {
            compatibilities.getStorageSimilarity().add((Object)this.createStorageSimilarity("Normal", normalNanoEntities));
        }
        if (!highNanoEntities.isEmpty()) {
            compatibilities.getStorageSimilarity().add((Object)this.createStorageSimilarity("Huge", highNanoEntities));
        }
        if (!lowNanoEntities.isEmpty()) {
            compatibilities.getStorageSimilarity().add((Object)this.createStorageSimilarity("Tiny", lowNanoEntities));
        }
    }

    private void buildSecurityCriticalitySets(Compatibilities compatibilities) {
        compatibilities.getSecurityCriticality().clear();
        Set<String> normalNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getSecurityCriticality() == Criticality.NORMAL);
        Set<String> highNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getSecurityCriticality() == Criticality.HIGH);
        Set<String> lowNanoEntities = this.getNanoentities4AggregatePredicate(agg -> agg.getSecurityCriticality() == Criticality.LOW);
        if (!normalNanoEntities.isEmpty()) {
            compatibilities.getSecurityCriticality().add((Object)this.createSecurityCriticality("Internal", normalNanoEntities));
        }
        if (!highNanoEntities.isEmpty()) {
            compatibilities.getSecurityCriticality().add((Object)this.createSecurityCriticality("Critical", highNanoEntities));
        }
        if (!lowNanoEntities.isEmpty()) {
            compatibilities.getSecurityCriticality().add((Object)this.createSecurityCriticality("Public", lowNanoEntities));
        }
    }

    private StructuralVolatility createStructuralVolatility(String characteristic, Set<String> nanoentities) {
        StructuralVolatility structuralVolatility = ServiceCutterConfigurationDSLFactory.eINSTANCE.createStructuralVolatility();
        structuralVolatility.setCharacteristic(characteristic);
        structuralVolatility.getNanoentities().addAll(nanoentities);
        return structuralVolatility;
    }

    private ContentVolatility createContentVolatility(String characteristic, Set<String> nanoentities) {
        ContentVolatility contentVolatility = ServiceCutterConfigurationDSLFactory.eINSTANCE.createContentVolatility();
        contentVolatility.setCharacteristic(characteristic);
        contentVolatility.getNanoentities().addAll(nanoentities);
        return contentVolatility;
    }

    private AvailabilityCriticality createAvailabilityCriticality(String characteristic, Set<String> nanoentities) {
        AvailabilityCriticality availabilityCriticality = ServiceCutterConfigurationDSLFactory.eINSTANCE.createAvailabilityCriticality();
        availabilityCriticality.setCharacteristic(characteristic);
        availabilityCriticality.getNanoentities().addAll(nanoentities);
        return availabilityCriticality;
    }

    private ConsistencyCriticality createConsistencyCriticality(String characteristic, Set<String> nanoentities) {
        ConsistencyCriticality consistencyCriticality = ServiceCutterConfigurationDSLFactory.eINSTANCE.createConsistencyCriticality();
        consistencyCriticality.setCharacteristic(characteristic);
        consistencyCriticality.getNanoentities().addAll(nanoentities);
        return consistencyCriticality;
    }

    private StorageSimilarity createStorageSimilarity(String characteristic, Set<String> nanoentities) {
        StorageSimilarity storageSimilarity = ServiceCutterConfigurationDSLFactory.eINSTANCE.createStorageSimilarity();
        storageSimilarity.setCharacteristic(characteristic);
        storageSimilarity.getNanoentities().addAll(nanoentities);
        return storageSimilarity;
    }

    private SecurityCriticality createSecurityCriticality(String characteristic, Set<String> nanoentities) {
        SecurityCriticality securityCriticality = ServiceCutterConfigurationDSLFactory.eINSTANCE.createSecurityCriticality();
        securityCriticality.setCharacteristic(characteristic);
        securityCriticality.getNanoentities().addAll(nanoentities);
        return securityCriticality;
    }

    private Set<String> getNanoentities4AggregatePredicate(Predicate<Aggregate> aggregatePredicate) {
        HashSet nanoentities = Sets.newHashSet();
        for (Aggregate aggregate : this.resolvingHelper.resolveAllAggregates().stream().filter(aggregatePredicate).collect(Collectors.toList())) {
            nanoentities.addAll(this.nanoentityResolver.getAllNanoentities(aggregate));
        }
        return nanoentities;
    }
}

