/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.sketchminer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.contextmapper.dsl.generator.sketchminer.model.Task;
import org.contextmapper.dsl.generator.sketchminer.model.TaskSequence;

public class SketchMinerModel {
    private List<TaskSequence> sequences = Lists.newLinkedList();
    private String defaultActorName;

    public SketchMinerModel(String defaultActorName) {
        this.defaultActorName = defaultActorName;
    }

    public void addSequence(TaskSequence sequence) {
        this.sequences.add(sequence);
    }

    public String getDefaultActorName() {
        return this.defaultActorName;
    }

    public List<TaskSequence> getSequences() {
        return Lists.newLinkedList(this.sequences);
    }

    public void cleanupDuplicateSequences() {
        List<TaskSequence> oldSequences = this.sequences;
        LinkedList newSequences = Lists.newLinkedList();
        for (TaskSequence seq : oldSequences) {
            if (this.containsSequence(newSequences, seq)) continue;
            newSequences.add(seq);
        }
        this.sequences = Lists.newLinkedList((Iterable)newSequences);
    }

    public boolean hasMultipleActors() {
        HashSet actors = Sets.newHashSet();
        actors.add(this.defaultActorName);
        for (TaskSequence seq : this.sequences) {
            for (Task task : seq.getTasks()) {
                if (task.getActor() == null) continue;
                actors.add(task.getActor());
            }
        }
        return actors.size() > 1;
    }

    private boolean containsSequence(List<TaskSequence> seqList, TaskSequence testSeq) {
        for (TaskSequence seq : seqList) {
            if (!seq.isEqualToOtherSequence(testSeq)) continue;
            return true;
        }
        return false;
    }
}

