/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.api;

import ch.hsr.servicecutter.analyzer.ServiceCutAnalyzer;
import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.api.model.SolverResult;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.scorer.Score;
import ch.hsr.servicecutter.scorer.Scorer;
import ch.hsr.servicecutter.solver.AbstractSolver;
import ch.hsr.servicecutter.solver.ChineseWhispersSolver;
import ch.hsr.servicecutter.solver.GraphStreamSolver;
import ch.hsr.servicecutter.solver.MarkovSolver;
import ch.hsr.servicecutter.solver.SolverAlgorithm;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCutter {
    private final Logger log = LoggerFactory.getLogger(ServiceCutter.class);
    private ServiceCutterContext context;
    private Scorer scorer;
    private ServiceCutAnalyzer analyzer;

    public ServiceCutter(ServiceCutterContext context) {
        this.context = context;
        this.scorer = new Scorer(context.getCouplingInstances(), context.getNanoEntities());
        this.analyzer = new ServiceCutAnalyzer(context);
    }

    public SolverResult generateDecomposition() {
        if (this.context.getSolverConfiguration().getPriorities().isEmpty()) {
            return new SolverResult();
        }
        AbstractSolver solver = null;
        SolverAlgorithm algorithm = this.context.getSolverConfiguration().getAlgorithm();
        Map<EntityPair, Map<String, Score>> scores = this.scorer.getScores(key -> this.context.getSolverConfiguration().getPriorityForCouplingCriterion((String)key).toValue());
        if (SolverAlgorithm.LEUNG.equals((Object)algorithm)) {
            solver = new GraphStreamSolver(this.context, scores, this.context.getSolverConfiguration());
        } else if (SolverAlgorithm.CHINESE_WHISPERS.equals((Object)algorithm)) {
            solver = new ChineseWhispersSolver(this.context, scores, this.context.getSolverConfiguration());
        } else if (SolverAlgorithm.MARKOV_CLUSTERING.equals((Object)algorithm)) {
            solver = new MarkovSolver(this.context, scores, this.context.getSolverConfiguration());
        } else {
            throw new RuntimeException("Algorithm " + algorithm.toString() + " not found!");
        }
        this.log.info("created graph");
        SolverResult result = solver.solve();
        this.log.info("found clusters");
        this.log.info("userSystem {} solved, found {} bounded contexts: {}", new Object[]{this.context.getSystemName(), result.getServices().size(), result.toString()});
        if (result.getServices().size() > 0) {
            this.analyzer.analyseResult(result, scores);
        }
        return result;
    }
}

