/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.api;

import ch.hsr.servicecutter.solver.SolverAlgorithm;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import ch.hsr.servicecutter.solver.SolverPriority;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;

public class SolverConfigurationFactory {
    public SolverConfiguration createDefaultConfiguration() {
        SolverConfiguration configuration = new SolverConfiguration();
        configuration.setAlgorithm(SolverAlgorithm.MARKOV_CLUSTERING);
        configuration.setAlgorithmParam("leungM", 0.1);
        configuration.setAlgorithmParam("leungDelta", 0.55);
        configuration.setAlgorithmParam("mclExpansionOperations", 2.0);
        configuration.setAlgorithmParam("mclPowerCoefficient", 2.0);
        configuration.setAlgorithmParam("cwNodeWeighting", 0.0);
        configuration.setPriority("Identity & Lifecycle Commonality", SolverPriority.M);
        configuration.setPriority("Semantic Proximity", SolverPriority.M);
        configuration.setPriority("Shared Owner", SolverPriority.M);
        configuration.setPriority("Structural Volatility", SolverPriority.XS);
        configuration.setPriority("Identity & Lifecycle Commonality", SolverPriority.M);
        configuration.setPriority("Latency", SolverPriority.M);
        configuration.setPriority("Consistency Criticality", SolverPriority.XS);
        configuration.setPriority("Availability Criticality", SolverPriority.XS);
        configuration.setPriority("Content Volatility", SolverPriority.XS);
        configuration.setPriority("Consistency Constraint", SolverPriority.M);
        configuration.setPriority("Storage Similarity", SolverPriority.XS);
        configuration.setPriority("Predefined Service Constraint", SolverPriority.M);
        configuration.setPriority("Security Contextuality", SolverPriority.M);
        configuration.setPriority("Security Criticality", SolverPriority.XS);
        configuration.setPriority("Security Constraint", SolverPriority.M);
        return configuration;
    }

    public SolverConfiguration createConfigurationWithJSONFile(File jsonFile) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (SolverConfiguration)objectMapper.readValue(jsonFile, SolverConfiguration.class);
    }
}

