/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.model.usersystem;

import ch.hsr.servicecutter.model.criteria.CouplingCriterion;
import ch.hsr.servicecutter.model.criteria.CouplingCriterionCharacteristic;
import ch.hsr.servicecutter.model.criteria.CouplingType;
import ch.hsr.servicecutter.model.usersystem.InstanceType;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;

public class CouplingInstance
implements Comparable<CouplingInstance> {
    private String name;
    private List<Nanoentity> nanoentities = new ArrayList<Nanoentity>();
    private CouplingCriterion couplingCriterion;
    private CouplingCriterionCharacteristic characteristic;
    private List<Nanoentity> secondNanoentities = new ArrayList<Nanoentity>();
    private InstanceType instanceType;

    public CouplingInstance(CouplingCriterion couplingCriterion, InstanceType type) {
        Assert.assertNotEquals((String)"Constructor only to be used for not-compatibility criteria!", (Object)((Object)CouplingType.COMPATIBILITY), (Object)((Object)couplingCriterion.getType()));
        this.instanceType = type;
        this.couplingCriterion = couplingCriterion;
    }

    public CouplingInstance(CouplingCriterionCharacteristic characteristic, InstanceType type) {
        this.instanceType = type;
        this.setCharacteristicAndCriterion(characteristic);
    }

    public CouplingInstance() {
    }

    public List<Nanoentity> getNanoentities() {
        return Collections.unmodifiableList(this.nanoentities);
    }

    public void addNanoentity(Nanoentity nanoentity) {
        this.nanoentities.add(nanoentity);
    }

    public void setNanoentities(Collection<Nanoentity> nanoentities) {
        this.nanoentities.clear();
        if (nanoentities != null) {
            this.nanoentities.addAll(nanoentities);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CouplingCriterion getCouplingCriterion() {
        return this.couplingCriterion;
    }

    public CouplingCriterionCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    public List<Nanoentity> getSecondNanoentities() {
        return Collections.unmodifiableList(this.secondNanoentities);
    }

    public void setSecondNanoentities(List<Nanoentity> secondNanoentities) {
        this.secondNanoentities.clear();
        if (secondNanoentities != null) {
            this.secondNanoentities.addAll(secondNanoentities);
        }
    }

    public List<Nanoentity> getAllNanoentities() {
        ArrayList<Nanoentity> result = new ArrayList<Nanoentity>();
        result.addAll(this.nanoentities);
        result.addAll(this.secondNanoentities);
        return result;
    }

    private void setCharacteristicAndCriterion(CouplingCriterionCharacteristic characteristic) {
        Assert.assertNotNull((Object)characteristic);
        this.characteristic = characteristic;
        this.couplingCriterion = characteristic.getCouplingCriterion();
    }

    @Override
    public int compareTo(CouplingInstance o) {
        return this.couplingCriterion.getName().compareTo(o.getCouplingCriterion().getName());
    }

    public InstanceType getType() {
        return this.instanceType;
    }
}

