/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.scorer;

import ch.hsr.servicecutter.model.criteria.CouplingType;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.model.usersystem.CouplingInstance;
import ch.hsr.servicecutter.model.usersystem.InstanceType;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.scorer.Score;
import ch.hsr.servicecutter.scorer.criterionScorer.CharacteristicsCriteriaScorer;
import ch.hsr.servicecutter.scorer.criterionScorer.CohesiveGroupCriterionScorer;
import ch.hsr.servicecutter.scorer.criterionScorer.ExclusiveGroupCriterionScorer;
import ch.hsr.servicecutter.scorer.criterionScorer.SemanticProximityCriterionScorer;
import ch.hsr.servicecutter.scorer.criterionScorer.SeparatedGroupCriterionScorer;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scorer {
    public static final double MAX_SCORE = 10.0;
    public static final double MIN_SCORE = -10.0;
    public static final double NO_SCORE = 0.0;
    private Logger log = LoggerFactory.getLogger(Scorer.class);
    private List<CouplingInstance> couplingInstanceList;
    private Set<Nanoentity> nanoentitySet;

    public Scorer(List<CouplingInstance> couplingInstanceList, Set<Nanoentity> nanoentitySet) {
        this.couplingInstanceList = couplingInstanceList;
        this.nanoentitySet = nanoentitySet;
    }

    public Map<EntityPair, Map<String, Score>> getScores(Function<String, Double> priorityProvider) {
        if (new HashSet<CouplingInstance>(this.couplingInstanceList).isEmpty()) {
            throw new InvalidParameterException("userSystem needs at least 1 coupling criterion in order for gephi clusterer to work");
        }
        HashMap<EntityPair, Map<String, Score>> result = new HashMap<EntityPair, Map<String, Score>>();
        this.addScoresForCharacteristicsCriteria(priorityProvider, result);
        this.addScoresForConstraintsCriteria(priorityProvider, result);
        this.addScoresForProximityCriteria(priorityProvider, result);
        return result;
    }

    private Set<CouplingInstance> getCouplingInstancesByCriterionName(String criterionName) {
        return this.couplingInstanceList.stream().filter(ci -> criterionName.equals(ci.getCouplingCriterion().getName())).collect(Collectors.toSet());
    }

    private Set<CouplingInstance> getCouplingInstancesByType(InstanceType instanceType) {
        return this.couplingInstanceList.stream().filter(ci -> instanceType.equals((Object)ci.getType())).collect(Collectors.toSet());
    }

    private Map<String, Set<CouplingInstance>> getCouplingInstancesByCouplingType(CouplingType couplingType) {
        return this.groupByCriterion(this.couplingInstanceList.stream().filter(ci -> couplingType.equals((Object)ci.getCouplingCriterion().getType())).collect(Collectors.toSet()));
    }

    private void addScoresForProximityCriteria(Function<String, Double> priorityProvider, Map<EntityPair, Map<String, Score>> result) {
        Map<EntityPair, Double> lifecycleScores = new CohesiveGroupCriterionScorer().getScores(this.getCouplingInstancesByCriterionName("Identity & Lifecycle Commonality"));
        this.addScoresByCriterionToResult(result, "Identity & Lifecycle Commonality", lifecycleScores, priorityProvider.apply("Identity & Lifecycle Commonality"));
        Map<EntityPair, Double> semanticProximityScores = new SemanticProximityCriterionScorer().getScores(this.getCouplingInstancesByCriterionName("Semantic Proximity"));
        this.addScoresByCriterionToResult(result, "Semantic Proximity", semanticProximityScores, priorityProvider.apply("Semantic Proximity"));
        Map<EntityPair, Double> responsibilityScores = new CohesiveGroupCriterionScorer().getScores(this.getCouplingInstancesByCriterionName("Shared Owner"));
        this.addScoresByCriterionToResult(result, "Shared Owner", responsibilityScores, priorityProvider.apply("Shared Owner"));
        Map<EntityPair, Double> latencyScores = new CohesiveGroupCriterionScorer().getScores(this.getCouplingInstancesByType(InstanceType.LATENCY_USE_CASE));
        this.addScoresByCriterionToResult(result, "Latency", latencyScores, priorityProvider.apply("Latency"));
        Map<EntityPair, Double> securityContextualityScores = new CohesiveGroupCriterionScorer().getScores(this.getCouplingInstancesByCriterionName("Security Contextuality"));
        this.addScoresByCriterionToResult(result, "Security Contextuality", securityContextualityScores, priorityProvider.apply("Security Contextuality"));
    }

    private void addScoresForCharacteristicsCriteria(Function<String, Double> priorityProvider, Map<EntityPair, Map<String, Score>> result) {
        Map<String, Map<EntityPair, Double>> scoresByCriterion = new CharacteristicsCriteriaScorer().getScores(this.getCouplingInstancesByCouplingType(CouplingType.COMPATIBILITY));
        for (Map.Entry<String, Map<EntityPair, Double>> distanceScores : scoresByCriterion.entrySet()) {
            this.addScoresByCriterionToResult(result, distanceScores.getKey(), distanceScores.getValue(), priorityProvider.apply(distanceScores.getKey()));
        }
    }

    private void addScoresForConstraintsCriteria(Function<String, Double> priorityProvider, Map<EntityPair, Map<String, Score>> result) {
        Map<EntityPair, Double> securityScores = new SeparatedGroupCriterionScorer().getScores(this.getCouplingInstancesByCriterionName("Security Constraint"));
        this.addScoresByCriterionToResult(result, "Security Constraint", securityScores, priorityProvider.apply("Security Constraint"));
        Map<EntityPair, Double> predefinedServiceScores = new ExclusiveGroupCriterionScorer(this.nanoentitySet).getScores(this.getCouplingInstancesByCriterionName("Predefined Service Constraint"));
        this.addScoresByCriterionToResult(result, "Predefined Service Constraint", predefinedServiceScores, priorityProvider.apply("Predefined Service Constraint"));
        Map<EntityPair, Double> consistencyConstraintScores = new CohesiveGroupCriterionScorer().getScores(this.getCouplingInstancesByCriterionName("Consistency Constraint"));
        this.addScoresByCriterionToResult(result, "Consistency Constraint", consistencyConstraintScores, priorityProvider.apply("Consistency Constraint"));
    }

    private void addScoresByCriterionToResult(Map<EntityPair, Map<String, Score>> result, String couplingCriterionName, Map<EntityPair, Double> scores, Double priority) {
        for (Map.Entry<EntityPair, Double> nanoentityScore : scores.entrySet()) {
            this.addScoresToResult(result, nanoentityScore.getKey(), couplingCriterionName, nanoentityScore.getValue(), priority);
        }
    }

    private void addScoresToResult(Map<EntityPair, Map<String, Score>> result, EntityPair nanoentities, String criterionName, double score, double priority) {
        if (nanoentities.nanoentityA.equals(nanoentities.nanoentityB)) {
            this.log.warn("score on same nanoentity ignored. Nanoentity: {}, Score: {}, Criterion: {}", new Object[]{nanoentities.nanoentityA, score, criterionName});
            return;
        }
        if (result.get(nanoentities) == null) {
            result.put(nanoentities, new HashMap());
        }
        result.get(nanoentities).put(criterionName, new Score(score, priority));
    }

    private Map<String, Set<CouplingInstance>> groupByCriterion(Set<CouplingInstance> instances) {
        HashMap<String, Set<CouplingInstance>> instancesByCriterion = new HashMap<String, Set<CouplingInstance>>();
        for (CouplingInstance instance : instances) {
            String ccName = instance.getCouplingCriterion().getName();
            if (instancesByCriterion.get(ccName) == null) {
                instancesByCriterion.put(ccName, new HashSet());
            }
            ((Set)instancesByCriterion.get(ccName)).add(instance);
        }
        return instancesByCriterion;
    }
}

