/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.scorer.criterionScorer;

import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.model.usersystem.CouplingInstance;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.scorer.criterionScorer.CriterionScorer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CharacteristicsCriteriaScorer
implements CriterionScorer {
    public Map<String, Map<EntityPair, Double>> getScores(Map<String, Set<CouplingInstance>> instancesByCriterion) {
        HashMap<String, Map<EntityPair, Double>> result = new HashMap<String, Map<EntityPair, Double>>();
        for (Map.Entry<String, Set<CouplingInstance>> instancesEntry : instancesByCriterion.entrySet()) {
            result.put(instancesEntry.getKey(), this.getScores(instancesEntry.getValue()));
        }
        return result;
    }

    @Override
    public Map<EntityPair, Double> getScores(Set<CouplingInstance> instances) {
        HashMap<EntityPair, Double> resultPerCC = new HashMap<EntityPair, Double>();
        ArrayList characteristics = Lists.newArrayList(instances);
        for (int i = 0; i < characteristics.size() - 1; ++i) {
            for (int j = i + 1; j < characteristics.size(); ++j) {
                CouplingInstance characteristicI = (CouplingInstance)characteristics.get(i);
                CouplingInstance characteristicJ = (CouplingInstance)characteristics.get(j);
                for (Nanoentity nanoentityFromI : characteristicI.getAllNanoentities()) {
                    for (Nanoentity nanoentityFromJ : characteristicJ.getAllNanoentities()) {
                        int distance = Math.abs(characteristicI.getCharacteristic().getWeight() - characteristicJ.getCharacteristic().getWeight());
                        if (distance == 0) continue;
                        resultPerCC.put(new EntityPair(nanoentityFromI, nanoentityFromJ), (double)distance * -1.0);
                    }
                }
            }
        }
        return resultPerCC;
    }
}

