/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.solver;

import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.scorer.Score;
import ch.hsr.servicecutter.solver.Solver;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolver<N, E>
implements Solver {
    private ServiceCutterContext context;
    private final Logger log = LoggerFactory.getLogger(AbstractSolver.class);
    private Map<EntityPair, Map<String, Score>> scores;

    public AbstractSolver(ServiceCutterContext context, Map<EntityPair, Map<String, Score>> scores) {
        this.context = context;
        this.scores = scores;
        this.log.info("Created solver of type {}", this.getClass());
    }

    protected abstract void createNode(String var1);

    protected N getNode(Nanoentity nanoentity) {
        return this.getNode(this.createNodeIdentifier(nanoentity));
    }

    protected abstract N getNode(String var1);

    protected abstract void createEdgeAndSetWeight(Nanoentity var1, Nanoentity var2, double var3);

    protected abstract void removeEdge(E var1);

    protected abstract E getEdge(Nanoentity var1, Nanoentity var2);

    protected abstract Iterable<E> getEdges();

    protected abstract double getWeight(E var1);

    protected abstract void setWeight(E var1, double var2);

    protected void buildNodes() {
        for (Nanoentity nanoentity : this.context.getNanoEntities()) {
            this.createNode(this.createNodeIdentifier(nanoentity));
        }
    }

    protected void buildEdges() {
        for (Map.Entry<EntityPair, Map<String, Score>> entry : this.scores.entrySet()) {
            this.setWeight(entry.getKey().nanoentityA, entry.getKey().nanoentityB, entry.getValue().values().stream().mapToDouble(Score::getPrioritizedScore).sum());
            this.log.info("Score for nanoentity tuple {}", (Object)entry.getKey());
            for (Map.Entry<String, Score> criteriaScores : entry.getValue().entrySet()) {
                this.log.info("{}: {} with priority {} results in {}", new Object[]{criteriaScores.getKey(), criteriaScores.getValue().getScore(), criteriaScores.getValue().getPriority(), criteriaScores.getValue().getPrioritizedScore()});
            }
            this.log.info("---------------------------------------------------");
        }
        this.deleteNegativeEdges();
    }

    protected String createNodeIdentifier(Nanoentity nanoentity) {
        return nanoentity.getContextName();
    }

    private void deleteNegativeEdges() {
        ArrayList<E> edgesToRemove = new ArrayList<E>();
        for (E edge : this.getEdges()) {
            if (!(this.getWeight(edge) <= 0.0)) continue;
            edgesToRemove.add(edge);
        }
        this.log.info("Deleting {} edges with zero or negative weight", (Object)edgesToRemove.size());
        for (E edge : edgesToRemove) {
            this.removeEdge(edge);
        }
    }

    protected void setWeight(Nanoentity first, Nanoentity second, double weight) {
        N nodeA = this.getNode(first);
        N nodeB = this.getNode(second);
        E existingEdge = this.getEdge(first, second);
        if (existingEdge != null) {
            this.log.info("add {} to weight of edge from node {} to {}", new Object[]{weight, nodeA, nodeB});
            this.setWeight(existingEdge, weight);
        } else {
            this.log.info("create edge with weight {} from node {} to {}", new Object[]{weight, nodeA, nodeB});
            this.createEdgeAndSetWeight(first, second, weight);
        }
    }

    protected char generateNextServiceId(char currentId) {
        if (currentId == 'Z') {
            return 'a';
        }
        if (currentId == 'z') {
            return '0';
        }
        if (currentId == '9') {
            throw new RuntimeException("Result produced too many services. More than 62 services currently not supported.");
        }
        currentId = (char)(currentId + '\u0001');
        return currentId;
    }
}

