/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.solver;

import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.scorer.Score;
import ch.hsr.servicecutter.solver.AbstractWatsetSolver;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import java.util.Map;
import org.nlpub.watset.graph.ChineseWhispers;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.NodeWeighting;

public class ChineseWhispersSolver
extends AbstractWatsetSolver {
    private final NodeWeighting nodeWeighting;

    public ChineseWhispersSolver(ServiceCutterContext context, Map<EntityPair, Map<String, Score>> scores, SolverConfiguration config) {
        super(context, scores);
        this.nodeWeighting = this.mapNodeWeightingConfig(config.getValueForAlgorithmParam("cwNodeWeighting", 0.0).intValue());
    }

    @Override
    protected Clustering<String> getAlgorithm() {
        return new ChineseWhispers(this.graph, this.nodeWeighting);
    }

    private NodeWeighting mapNodeWeightingConfig(int nodeWeighting) {
        switch (nodeWeighting) {
            case 1: {
                return NodeWeighting.label();
            }
            case 2: {
                return NodeWeighting.linear();
            }
            case 3: {
                return NodeWeighting.log();
            }
        }
        return NodeWeighting.top();
    }
}

