/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.solver;

import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.scorer.Score;
import ch.hsr.servicecutter.solver.AbstractWatsetSolver;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import java.util.Map;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.MarkovClustering;

public class MarkovSolver
extends AbstractWatsetSolver {
    private int expansionOperations;
    private double powerCoefficient;

    public MarkovSolver(ServiceCutterContext context, Map<EntityPair, Map<String, Score>> scores, SolverConfiguration config) {
        super(context, scores);
        this.expansionOperations = config.getValueForAlgorithmParam("mclExpansionOperations", 2.0).intValue();
        this.powerCoefficient = config.getValueForAlgorithmParam("mclPowerCoefficient", 2.0);
    }

    @Override
    protected Clustering<String> getAlgorithm() {
        return new MarkovClustering(this.graph, this.expansionOperations, this.powerCoefficient);
    }
}

