/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.solver;

import ch.hsr.servicecutter.solver.SolverAlgorithm;
import ch.hsr.servicecutter.solver.SolverPriority;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverConfiguration {
    private Map<String, Double> algorithmParams = new HashMap<String, Double>();
    private Map<String, SolverPriority> priorities = new HashMap<String, SolverPriority>();
    private SolverAlgorithm algorithm = SolverAlgorithm.MARKOV_CLUSTERING;
    private Logger log = LoggerFactory.getLogger(SolverConfiguration.class);

    public void setAlgorithmParam(String param, Double value) {
        this.algorithmParams.put(param, value);
    }

    public Map<String, SolverPriority> getPriorities() {
        return this.priorities;
    }

    public void setPriority(String criterionType, SolverPriority priority) {
        if (priority == null) {
            throw new InvalidParameterException();
        }
        this.priorities.put(criterionType, priority);
    }

    public Map<String, Double> getAlgorithmParams() {
        return this.algorithmParams;
    }

    public SolverPriority getPriorityForCouplingCriterion(String criterionType) {
        if (!this.priorities.containsKey(criterionType)) {
            this.log.error("no priority defined for couplingCriterion: " + criterionType + ". Use 1");
            return SolverPriority.S;
        }
        return this.priorities.get(criterionType);
    }

    public Double getValueForAlgorithmParam(String key, Double defaultValue) {
        if (!this.algorithmParams.containsKey(key)) {
            this.log.warn("no value defined for algorithm param: " + key + ". Use default value: " + defaultValue);
            return defaultValue;
        }
        return this.algorithmParams.get(key);
    }

    public void setAlgorithm(SolverAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public SolverAlgorithm getAlgorithm() {
        return this.algorithm;
    }
}

