/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apm.mysql8;

import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.log.Log;
import java.util.Properties;
import org.coodex.concrete.apm.Trace;
import org.coodex.concrete.apm.mysql8.TracingQueryInterceptor;

public class TracingExceptionInterceptor
implements ExceptionInterceptor {
    public ExceptionInterceptor init(Properties properties, Log log) {
        String queryInterceptors = properties.getProperty("queryInterceptors");
        if (queryInterceptors == null || !queryInterceptors.contains(TracingQueryInterceptor.class.getName())) {
            throw new IllegalStateException("TracingQueryInterceptor must be enabled to use TracingExceptionInterceptor.");
        }
        return new TracingExceptionInterceptor();
    }

    public void destroy() {
    }

    public Exception interceptException(Exception e) {
        Trace trace = TracingQueryInterceptor.traceThreadLocal.get();
        TracingQueryInterceptor.traceThreadLocal.remove();
        if (trace != null) {
            trace.error((Throwable)e);
            trace.finish();
        }
        return null;
    }
}

