/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.fsm.impl;

import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.fsm.IdentifiedState;
import org.coodex.concrete.fsm.IdentifiedStateContainer;
import org.coodex.concrete.fsm.IdentifiedStateIsLockingException;
import org.coodex.concrete.fsm.IdentifiedStateLoader;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;

public class SingletonIdentifiedStateContainer
implements IdentifiedStateContainer {
    private static final Map<Serializable, Lock> STATUS_MAP = new ConcurrentHashMap<Serializable, Lock>();
    private static final ServiceLoader<IdentifiedStateLoader> LOADERS = new ServiceLoaderImpl<IdentifiedStateLoader>(){};
    private static final long DEFAULT_TIME_OUT = 1000L;
    private static final Map<Class, IdentifiedStateLoader> loaderMap = new HashMap<Class, IdentifiedStateLoader>();

    private static ScheduledExecutorService getReleaseExecutor() {
        return ConcreteHelper.getScheduler((String)"fsm.lock.release");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S extends IdentifiedState<ID>, ID extends Serializable, L extends IdentifiedStateLoader<S, ID>> L getLoader(Class<? extends S> stateClass) {
        Map<Class, IdentifiedStateLoader> map = loaderMap;
        synchronized (map) {
            if (!loaderMap.containsKey(stateClass)) {
                TypeVariable t = IdentifiedStateLoader.class.getTypeParameters()[0];
                boolean found = false;
                for (IdentifiedStateLoader loader : LOADERS.getAll().values()) {
                    if (!stateClass.equals(GenericTypeHelper.toReference(t, loader.getClass()))) continue;
                    loaderMap.put(stateClass, loader);
                    found = true;
                    break;
                }
                if (!found) {
                    throw new RuntimeException("No IdentifiedStateLoader found for " + stateClass.getName());
                }
            }
            return (L)loaderMap.get(stateClass);
        }
    }

    public <S extends IdentifiedState<ID>, ID extends Serializable> S newStateAndLock(Class<? extends S> stateClass) {
        return this.newStateAndLock(stateClass, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends IdentifiedState<ID>, ID extends Serializable> S newStateAndLock(Class<? extends S> stateClass, long timeout) {
        Map<Serializable, Lock> map = STATUS_MAP;
        synchronized (map) {
            return (S)this.lock(SingletonIdentifiedStateContainer.getLoader(stateClass).newState(), timeout);
        }
    }

    private <S extends IdentifiedState<ID>, ID extends Serializable> S lock(S state, long timeout) {
        if (timeout <= 0L) {
            timeout = 1000L;
        }
        STATUS_MAP.put(state.getId(), new Lock(state, SingletonIdentifiedStateContainer.getReleaseExecutor().schedule(() -> this.$release(state.getId(), false), timeout, TimeUnit.MILLISECONDS)));
        return state;
    }

    public <S extends IdentifiedState<ID>, ID extends Serializable> S loadStateAndLock(ID id, Class<? extends S> stateClass) throws IdentifiedStateIsLockingException {
        return this.loadStateAndLock(id, stateClass, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends IdentifiedState<ID>, ID extends Serializable> S loadStateAndLock(ID id, Class<? extends S> stateClass, long timeoutInMS) throws IdentifiedStateIsLockingException {
        Map<Serializable, Lock> map = STATUS_MAP;
        synchronized (map) {
            if (STATUS_MAP.containsKey(id)) {
                throw new IdentifiedStateIsLockingException(id);
            }
            return (S)this.lock(SingletonIdentifiedStateContainer.getLoader(stateClass).getState(id), timeoutInMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $release(Serializable id, boolean cancelTask) {
        Map<Serializable, Lock> map = STATUS_MAP;
        synchronized (map) {
            if (STATUS_MAP.containsKey(id)) {
                Lock lock = STATUS_MAP.remove(id);
                if (cancelTask) {
                    lock.getFuture().cancel(true);
                }
            }
        }
    }

    public void release(Serializable id) {
        this.$release(id, true);
    }

    private static class Lock {
        private IdentifiedState identifiedState;
        private Future future;

        Lock(IdentifiedState identifiedState, Future future) {
            this.identifiedState = identifiedState;
            this.future = future;
        }

        public IdentifiedState getIdentifiedState() {
            return this.identifiedState;
        }

        Future getFuture() {
            return this.future;
        }
    }
}

