/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock.ext;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.coodex.mock.Mock;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Mock
public @interface IdCard {
    public Specification specification() default Specification.S18;

    public String[] divisions() default {};

    public int minAge() default 5;

    public int maxAge() default 90;

    public Sex sex() default Sex.RANDOM;

    public static enum Sex {
        RANDOM(-1),
        FEMALE(0),
        MALE(1);

        private final int sex;

        private Sex(int sex) {
            this.sex = sex;
        }

        public int getSex() {
            if (this.sex == -1) {
                return Math.random() < 0.5 ? 0 : 1;
            }
            return this.sex;
        }
    }

    public static enum Specification {
        RANDOM(-1),
        S15(15),
        S18(18);

        private final int size;

        private Specification(int size) {
            this.size = size;
        }

        public int getSize() {
            if (this.size == -1) {
                return Math.random() < 0.5 ? 15 : 18;
            }
            return this.size;
        }
    }
}

