/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.coodex.id.IDGenerator;
import org.coodex.util.Clock;

public class Parallel {
    private final ExecutorService executorService;
    private final RunnerWrapper wrapper;

    public Parallel() {
        this(null);
    }

    public Parallel(ExecutorService executorService) {
        this(executorService, null);
    }

    public Parallel(ExecutorService executorService, RunnerWrapper wrapper) {
        this.executorService = executorService;
        this.wrapper = wrapper;
    }

    public Batch run(Runnable ... runnables) {
        Batch batch = new Batch();
        batch.start = Clock.currentTimeMillis();
        if (runnables != null && runnables.length > 0) {
            CountDownLatch latch = new CountDownLatch(runnables.length);
            int i = 1;
            for (Runnable runnable : runnables) {
                batch.getTasks().add(this.newTask(this.wrapper == null ? runnable : this.wrapper.wrap(runnable), i++, latch));
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        batch.end = Clock.currentTimeMillis();
        return batch;
    }

    @SafeVarargs
    public final <V> CallableBatch<V> call(Callable<V> ... callable) {
        return this.call((CallableWrapper<V>)null, callable);
    }

    @SafeVarargs
    public final <V> CallableBatch<V> call(CallableWrapper<V> wrapper, Callable<V> ... callable) {
        CallableBatch batch = new CallableBatch();
        batch.start = Clock.currentTimeMillis();
        if (callable != null && callable.length > 0) {
            CountDownLatch latch = new CountDownLatch(callable.length);
            int i = 1;
            for (Callable<V> c : callable) {
                batch.getTasks().add(this.newTask(wrapper == null ? c : wrapper.wrap(c), i++, latch));
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        batch.end = Clock.currentTimeMillis();
        return batch;
    }

    private Task newTask(Runnable runnable, int i, CountDownLatch latch) {
        Task task = new Task();
        task.id = i;
        Runnable run = () -> {
            task.start = Clock.currentTimeMillis();
            try {
                runnable.run();
            }
            catch (Throwable th) {
                task.throwable = th;
            }
            finally {
                task.end = Clock.currentTimeMillis();
                task.finished = true;
                latch.countDown();
            }
        };
        if (this.executorService != null) {
            this.executorService.execute(run);
        } else {
            new Thread(run).start();
        }
        return task;
    }

    private <V> CallableTask<V> newTask(Callable<V> callable, int i, CountDownLatch latch) {
        CallableTask task = new CallableTask();
        task.id = i;
        Runnable run = () -> {
            task.start = Clock.currentTimeMillis();
            try {
                task.result = callable.call();
            }
            catch (Throwable th) {
                task.throwable = th;
            }
            finally {
                task.end = Clock.currentTimeMillis();
                task.finished = true;
                latch.countDown();
            }
        };
        if (this.executorService != null) {
            this.executorService.execute(run);
        } else {
            new Thread(run).start();
        }
        return task;
    }

    public static interface RunnerWrapper {
        public Runnable wrap(Runnable var1);
    }

    public static class Batch
    extends AbstractBatch {
        private final List<Task> tasks = new ArrayList<Task>();

        public List<Task> getTasks() {
            return this.tasks;
        }
    }

    public static class Task {
        long start;
        long end;
        Throwable throwable;
        boolean finished = false;
        Integer id;

        public long getTimeConsuming() {
            return this.end - this.start;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public Integer getId() {
            return this.id;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    public static interface CallableWrapper<V> {
        public Callable<V> wrap(Callable<V> var1);
    }

    public static class CallableBatch<V>
    extends AbstractBatch {
        private final List<CallableTask<V>> tasks = new ArrayList<CallableTask<V>>();

        public List<CallableTask<V>> getTasks() {
            return this.tasks;
        }
    }

    public static class CallableTask<V>
    extends Task {
        V result;

        public V getResult() {
            return this.result;
        }
    }

    private static class AbstractBatch {
        String id = IDGenerator.newId();
        long start;
        long end;

        private AbstractBatch() {
        }

        public long getTimeConsuming() {
            return this.end - this.start;
        }

        public String getId() {
            return this.id;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

