/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent.locks;

import org.coodex.concurrent.locks.AbstractResourceLock;
import org.coodex.concurrent.locks.AbstractResourceLockProvider;
import org.coodex.concurrent.locks.ResourceId;

public class LocalResourceLockProvider
extends AbstractResourceLockProvider {
    @Override
    public boolean accept(ResourceId param) {
        return param != null;
    }

    @Override
    protected AbstractResourceLock buildResourceLock(ResourceId id) {
        return new LocalResourceLock(id);
    }

    static class LocalResourceLock
    extends AbstractResourceLock {
        private volatile boolean allocated = false;

        public LocalResourceLock(ResourceId resourceId) {
            super(resourceId);
        }

        @Override
        protected void alloc() {
            this.allocated = true;
        }

        @Override
        protected boolean allocated() {
            return this.allocated;
        }

        @Override
        protected void release() {
            this.allocated = false;
        }

        @Override
        protected boolean tryAlloc() {
            this.allocated = true;
            return true;
        }

        @Override
        protected boolean tryAlloc(long time) {
            this.allocated = true;
            return true;
        }
    }
}

