/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent.locks;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.coodex.concurrent.locks.ResourceLock;

public class SyncWrapper {
    public static <V> V call(Lock lock, Callable<V> callable) throws Exception {
        return SyncWrapper.call(lock, 0L, callable);
    }

    public static <V> V call(final Lock lock, long time, Callable<V> callable) throws Exception {
        return SyncWrapper.call(new ResourceLock(){

            @Override
            public void lock() {
                lock.lock();
            }

            @Override
            public boolean tryLock() {
                return lock.tryLock();
            }

            @Override
            public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
                return lock.tryLock(time, unit);
            }

            @Override
            public void unlock() {
                lock.unlock();
            }
        }, time, callable);
    }

    public static <V> V call(ResourceLock lock, Callable<V> callable) throws Exception {
        return SyncWrapper.call(lock, 0L, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V call(ResourceLock lock, long time, Callable<V> callable) throws Exception {
        boolean locked;
        if (time > 0L) {
            locked = lock.tryLock(time, TimeUnit.MILLISECONDS);
        } else {
            lock.lock();
            locked = true;
        }
        if (locked) {
            try {
                V v = callable.call();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        throw new RuntimeException(String.format("try lock failed[%d ms]", time));
    }
}

