/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.count;

import java.util.Arrays;
import java.util.Collection;
import org.coodex.count.CountFacade;
import org.coodex.count.Countable;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;

public class CounterFacade {
    private static final ServiceLoader<CountFacade> COUNTER_FACTORY = new LazyServiceLoader<CountFacade>(){};

    public static <T extends Countable> void count(T value) {
        COUNTER_FACTORY.get().count(value);
    }

    @SafeVarargs
    public static <T extends Countable> void count(T ... value) {
        if (value != null && value.length > 0) {
            CounterFacade.count(Arrays.asList(value));
        }
    }

    public static <T extends Countable> void count(Collection<T> value) {
        for (Countable t : value) {
            COUNTER_FACTORY.get().count(t);
        }
    }
}

