/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.id;

import org.coodex.config.Config;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.Profile;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdWorker {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeIdWorker.class);
    static final Singleton<SnowflakeIdWorker> snowflakeIdWorkerSingleton = Singleton.with(() -> {
        SnowflakeIdWorker snowflakeIdWorker;
        int machineId = Config.getValue("snowflake.machineId", -1, new String[0]);
        if (machineId != -1) {
            snowflakeIdWorker = new SnowflakeIdWorker(machineId);
        } else {
            int workerId = Config.getValue("snowflake.workerId", -1, new String[0]);
            int dataCenterId = Config.getValue("snowflake.dataCenterId", -1, new String[0]);
            if (workerId == -1 && dataCenterId == -1) {
                machineId = Profile.get("idWorker").getInt("machineId", -1);
                if (machineId == -1) {
                    log.warn("snowflake parameters[machineId, workerId, dataCenterId] not set. use default value.");
                    machineId = 0;
                }
                snowflakeIdWorker = new SnowflakeIdWorker(machineId);
            } else {
                snowflakeIdWorker = new SnowflakeIdWorker(workerId, dataCenterId);
            }
        }
        return snowflakeIdWorker;
    });
    private final long twepoch = Common.calendar(2020).getTimeInMillis();
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDataCenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long dataCenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeIdWorker(int machineId) {
        this(machineId & 0x1F, machineId >> 5);
    }

    public SnowflakeIdWorker(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public static long getId() {
        return snowflakeIdWorkerSingleton.get().nextId();
    }

    public static Info parse(long snowflakeId) {
        return new Info(snowflakeId);
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return Clock.currentTimeMillis();
    }

    public static class Info {
        public final int workerId;
        public final int dataCenterId;
        public final int seq;
        public final long timestamp;

        Info(long id) {
            this.seq = (int)(id & 0xFFFL);
            this.workerId = (int)((id >>= 12) & 0x1FL);
            this.dataCenterId = (int)((id >>= 5) & 0x1FL);
            this.timestamp = (id >>= 5) & 0x1FFFFFFFFFFL;
        }

        public String toString() {
            return "Info{workerId=" + this.workerId + ", dataCenterId=" + this.dataCenterId + ", seq=" + this.seq + ", timestamp=" + this.timestamp + '}';
        }
    }
}

