/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.spring;

import java.util.Optional;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.annotation.Order;

@Named
@Order(value=-2147483648)
public class SpringBeanFactoryAware
implements SmartInstantiationAwareBeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanFactoryAware.class);
    private static ListableBeanFactory listableBeanFactory;
    private static boolean traced;

    public SpringBeanFactoryAware(ListableBeanFactory beanFactory) {
        listableBeanFactory = beanFactory;
        log.info("coodex-spring: listable bean factory injected. {}", Optional.ofNullable(beanFactory).map(Object::getClass).orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ListableBeanFactory getListableBeanFactory() {
        if (listableBeanFactory != null || !log.isDebugEnabled()) return listableBeanFactory;
        if (traced) {
            return listableBeanFactory;
        }
        Class<SpringBeanFactoryAware> clazz = SpringBeanFactoryAware.class;
        synchronized (SpringBeanFactoryAware.class) {
            StackTraceElement[] stackTraceElements;
            if (traced) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return listableBeanFactory;
            }
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement element : stackTraceElements = new Exception().getStackTrace()) {
                builder.append("\n\tat ").append(element);
            }
            log.debug("spring bean factory not injected yet.{}", (Object)builder);
            traced = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return listableBeanFactory;
        }
    }

    static {
        traced = false;
    }
}

