/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;
import org.coodex.util.Singleton;
import org.coodex.util.TimestampProvider;
import org.coodex.util.clock.ClockAgent;
import org.coodex.util.clock.DefaultClockAgent;
import org.coodex.util.clock.SystemClockAgent;

public final class Clock {
    public static final String KEY_MAGNIFICATION = Clock.class.getName() + ".magnification";
    private static final Singleton<ClockAgent> agentSingleton = Singleton.with(() -> {
        if (Clock.getMagnification().floatValue() == 1.0f) {
            return new SystemClockAgent();
        }
        return (ClockAgent)new LazyServiceLoader<ClockAgent>(){

            @Override
            protected ClockAgent getDefaultInstance() {
                return new DefaultClockAgent();
            }
        }.get();
    });
    private static final ServiceLoader<TimestampProvider> TIMESTAMP_PROVIDER_LOADER = new LazyServiceLoader<TimestampProvider>(Clock::getCalendar){};

    public static Calendar now() {
        return (Calendar)TIMESTAMP_PROVIDER_LOADER.get().now().clone();
    }

    public static Float getMagnification() {
        return Config.getValue(KEY_MAGNIFICATION, Common.to(System.getProperty(KEY_MAGNIFICATION), Float.valueOf(1.0f)), "clock");
    }

    public static long currentTimeMillis() {
        return agentSingleton.get().currentTimeMillis();
    }

    public static Calendar getCalendar() {
        return agentSingleton.get().getCalendar();
    }

    public static void sleep(long millis) throws InterruptedException {
        agentSingleton.get().sleep(millis);
    }

    public static void objWait(Object obj, long millis) throws InterruptedException {
        agentSingleton.get().objWait(obj, millis);
    }

    public static void sleep(TimeUnit timeUnit, long timeout) throws InterruptedException {
        agentSingleton.get().sleep(timeUnit, timeout);
    }

    public static long toMillis(long duration, TimeUnit timeUnit) {
        return agentSingleton.get().toMillis(duration, timeUnit);
    }
}

