/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

public enum Endianness {
    BIG_ENDIAN(false),
    LITTLE_ENDIAN(true);

    private final boolean reverse;

    private Endianness(boolean reverse) {
        this.reverse = reverse;
    }

    public int readDword(byte[] buf, int offset) {
        byte[] bits = this.read(buf, offset, 4);
        return Endianness.toInt(bits, 0);
    }

    public int readWord(byte[] buf, int offset) {
        byte[] bits = this.read(buf, offset, 2);
        return (bits[0] & 0xFF) << 8 | bits[1] & 0xFF;
    }

    public long readLong(byte[] buf, int offset) {
        byte[] bits = this.read(buf, offset, 8);
        return ((long)Endianness.toInt(bits, 0) & 0xFFFFFFFFL) << 32 | (long)Endianness.toInt(bits, 4) & 0xFFFFFFFFL;
    }

    public float readFloat(byte[] buf, int offset) {
        return Float.intBitsToFloat(this.readDword(buf, offset));
    }

    public double readDouble(byte[] buf, int offset) {
        return Double.longBitsToDouble(this.readLong(buf, offset));
    }

    public byte[] wordToByte(int value) {
        return this.getBytes(new byte[]{(byte)((short)value >>> 8), (byte)value});
    }

    public byte[] dwordToBytes(int value) {
        return this.getBytes(new byte[]{(byte)(value >>> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value});
    }

    public byte[] longToBytes(long value) {
        return this.getBytes(new byte[]{(byte)(value >>> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value});
    }

    public byte[] floatToBytes(float value) {
        return this.dwordToBytes(Float.floatToIntBits(value));
    }

    public byte[] doubleToBytes(double value) {
        return this.longToBytes(Double.doubleToLongBits(value));
    }

    private byte[] getBytes(byte[] output) {
        if (this.reverse) {
            return Endianness.reverseBytes(output);
        }
        return output;
    }

    private byte[] read(byte[] buf, int offset, int len) {
        if (offset + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException("offset: " + offset + " + len: " + len + " > buf size: " + buf.length);
        }
        byte[] output = new byte[len];
        System.arraycopy(buf, offset, output, 0, len);
        return this.getBytes(output);
    }

    public static byte[] reverseBytes(byte[] buf) {
        int i = 0;
        int len = buf.length;
        int j = len - 1;
        int mid = len / 2;
        while (i < mid) {
            byte b = buf[i];
            buf[i] = buf[j];
            buf[j] = b;
            ++i;
            --j;
        }
        return buf;
    }

    private static int toInt(byte[] bits, int offset) {
        return (bits[offset] & 0xFF) << 24 | (bits[offset + 1] & 0xFF) << 16 | (bits[offset + 2] & 0xFF) << 8 | bits[offset + 3] & 0xFF;
    }
}

