/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ReflectHelper;
import org.coodex.util.SelectableService;
import org.coodex.util.SelectableServiceLoader;
import org.coodex.util.ServiceLoader;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazySelectableServiceLoader<Param_Type, T extends SelectableService<Param_Type>>
implements SelectableServiceLoader<Param_Type, T>,
ServiceLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(LazySelectableServiceLoader.class);
    private final Singleton<List<T>> sortedServices = Singleton.with(this::sorted);
    private ServiceLoader<T> serviceLoaderFacade;
    private Supplier<T> defaultServiceSupplier;
    private final Singleton<T> defaultServiceSingleton = Singleton.with(() -> this.defaultServiceSupplier == null ? null : (SelectableService)this.defaultServiceSupplier.get());
    private Function<Method, RuntimeException> exceptionFunction = null;

    public LazySelectableServiceLoader() {
        this((SelectableService)null);
    }

    public LazySelectableServiceLoader(T defaultService) {
        this(defaultService == null ? null : () -> defaultService);
    }

    public LazySelectableServiceLoader(Supplier<T> defaultServiceSupplier) {
        this.defaultServiceSupplier = defaultServiceSupplier;
    }

    public LazySelectableServiceLoader(Function<Method, RuntimeException> exceptionFunction) {
        this.exceptionFunction = exceptionFunction;
    }

    protected Object getGenericTypeSearchContextObject() {
        return this;
    }

    protected Type getServiceType() {
        return GenericTypeHelper.solveFromInstance(SelectableServiceLoader.class.getTypeParameters()[1], this.getGenericTypeSearchContextObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceLoader<T> getServiceLoaderFacade() {
        LazyServiceLoader localServiceLoader = this.serviceLoaderFacade;
        if (localServiceLoader == null) {
            LazySelectableServiceLoader lazySelectableServiceLoader = this;
            synchronized (lazySelectableServiceLoader) {
                localServiceLoader = this.serviceLoaderFacade;
                if (localServiceLoader == null) {
                    SelectableService defaultService = (SelectableService)this.defaultServiceSingleton.get();
                    if (defaultService == null && this.exceptionFunction != null) {
                        defaultService = (SelectableService)Common.cast(Proxy.newProxyInstance(SelectableService.class.getClassLoader(), new Class[]{GenericTypeHelper.typeToClass(this.getServiceType())}, new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                if (method.getDeclaringClass().equals(Object.class)) {
                                    return method.invoke((Object)this, args);
                                }
                                if (method.getDeclaringClass().equals(SelectableService.class)) {
                                    return true;
                                }
                                throw (RuntimeException)LazySelectableServiceLoader.this.exceptionFunction.apply(method);
                            }
                        }));
                    }
                    final SelectableService finalDefaultService = defaultService;
                    this.serviceLoaderFacade = localServiceLoader = new LazyServiceLoader<T>(){

                        @Override
                        protected T getDefaultInstance() {
                            return finalDefaultService;
                        }

                        @Override
                        protected Type getServiceType() {
                            return LazySelectableServiceLoader.this.getServiceType();
                        }
                    };
                }
            }
        }
        return localServiceLoader;
    }

    private boolean accept(T instance, Param_Type param) {
        Class<?> paramClass;
        if (instance == null) {
            return false;
        }
        Class<?> clazz = paramClass = param == null ? null : param.getClass();
        if (paramClass == null) {
            return instance.accept(null);
        }
        if (ReflectHelper.isMatch(paramClass, GenericTypeHelper.solveFromInstance(SelectableService.class.getTypeParameters()[0], instance))) {
            return instance.accept(param);
        }
        return false;
    }

    @Override
    public List<T> selectAll(Param_Type param) {
        ArrayList<SelectableService> list = new ArrayList<SelectableService>();
        for (SelectableService instance : this.sortedServices.get()) {
            if (!this.accept(instance, param)) continue;
            list.add(instance);
        }
        try {
            SelectableService instance = (SelectableService)this.getServiceLoaderFacade().getDefault();
            if (this.accept(instance, param)) {
                list.add(instance);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    @Override
    public T select(Param_Type param) {
        for (SelectableService instance : this.sortedServices.get()) {
            if (!this.accept(instance, param)) continue;
            return (T)instance;
        }
        try {
            SelectableService instance = (SelectableService)this.getServiceLoaderFacade().getDefault();
            if (this.accept(instance, param)) {
                return (T)instance;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        log.info("no service instance accept this: {}", param);
        return null;
    }

    @Override
    public T get(Class<? extends T> providerClass) {
        return (T)((SelectableService)this.getServiceLoaderFacade().get(providerClass));
    }

    @Override
    public T get(String name) {
        return (T)((SelectableService)this.getServiceLoaderFacade().get(name));
    }

    @Override
    public T get() {
        return (T)((SelectableService)this.getServiceLoaderFacade().get());
    }

    @Override
    public T getDefault() {
        return (T)((SelectableService)this.getServiceLoaderFacade().getDefault());
    }

    @Override
    public Map<String, T> getAll() {
        return this.getServiceLoaderFacade().getAll();
    }
}

