/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.coodex.util.Common;

public class LoopQueue<E> {
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final int capacity;
    private final E[] data;
    private int head = 0;
    private int tail = 0;
    private int size = 0;

    public LoopQueue(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity of loop queue must be large then 0.");
        }
        this.capacity = capacity;
        this.data = (Object[])Common.cast(new Object[capacity]);
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private E[] getAllData() {
        if (this.isEmpty()) {
            return null;
        }
        int headRef = this.head;
        Object[] r = (Object[])Common.cast(new Object[this.size]);
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.data[headRef];
            headRef = (headRef + 1) % this.capacity;
        }
        return r;
    }

    public int size() {
        return this.size;
    }

    public void put(E e) {
        this.lock.lock();
        try {
            this.data[this.tail] = e;
            this.moveTail();
            if (this.size > this.capacity) {
                this.moveHead();
            }
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        this.lock.lock();
        try {
            E element = this.data[this.head];
            this.moveHead();
            E e = element;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E[] takeAll(long millis) {
        this.lock.lock();
        try {
            if (this.isEmpty()) {
                this.notEmpty.await(millis, TimeUnit.MILLISECONDS);
            }
            E[] r = this.getAllData();
            this.clear();
            E[] EArray = r;
            return EArray;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.head = 0;
            this.tail = 0;
            this.size = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void moveHead() {
        --this.size;
        this.head = (this.head + 1) % this.capacity;
    }

    private void moveTail() {
        ++this.size;
        this.tail = (this.tail + 1) % this.capacity;
    }

    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.data[this.head];
    }

    public String toString() {
        return "LoopQueue{capacity=" + this.capacity + ", head=" + this.head + ", tail=" + this.tail + ", size=" + this.size + ", data=" + Arrays.toString(this.getAllData()) + '}';
    }
}

