/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.ArrayList;
import java.util.List;
import org.coodex.util.Profile;

class MergedProfile
extends Profile {
    private final List<Profile> profiles = new ArrayList<Profile>();

    MergedProfile() {
    }

    MergedProfile merge(Profile profile) {
        if (profile != null && !this.profiles.contains(profile)) {
            if (profile instanceof MergedProfile) {
                for (Profile p : ((MergedProfile)profile).profiles) {
                    this.merge(p);
                }
            } else {
                this.profiles.add(profile);
            }
        }
        return this;
    }

    @Deprecated
    MergedProfile merge(String name) {
        if (name == null) {
            return this;
        }
        return this.merge(Profile.get(name));
    }

    private Profile getFirst(String key) {
        for (Profile p : this.profiles) {
            if (p.isNull(key)) continue;
            return p;
        }
        return NULL_PROFILE;
    }

    @Override
    public boolean getBool(String key, boolean v) {
        return this.getFirst(key).getBool(key, v);
    }

    @Override
    public boolean getBool(String key) {
        return this.getFirst(key).getBool(key);
    }

    @Override
    public String getString(String key, String v) {
        return this.getFirst(key).getString(key, v);
    }

    @Override
    public String getString(String key) {
        return this.getFirst(key).getString(key);
    }

    @Override
    public int getInt(String key) {
        return this.getFirst(key).getInt(key);
    }

    @Override
    public int getInt(String key, int v) {
        return this.getFirst(key).getInt(key, v);
    }

    @Override
    public long getLong(String key) {
        return this.getFirst(key).getLong(key);
    }

    @Override
    public long getLong(String key, long v) {
        return this.getFirst(key).getLong(key, v);
    }

    @Override
    public String[] getStrList(String key) {
        return this.getFirst(key).getStrList(key);
    }

    @Override
    public String[] getStrList(String key, String delim) {
        return this.getFirst(key).getStrList(key, delim);
    }

    @Override
    public String[] getStrList(String key, String delim, String[] v) {
        return this.getFirst(key).getStrList(key, delim, v);
    }

    @Override
    protected String getStringImpl(String key) {
        return this.getFirst(key).getStringImpl(key);
    }

    @Override
    protected boolean isNull(String key) {
        for (Profile p : this.profiles) {
            if (p.isNull(key)) continue;
            return false;
        }
        return true;
    }
}

