/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.coodex.util.Common;
import org.coodex.util.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileBaseProperties
extends Profile {
    private static final Logger log = LoggerFactory.getLogger(ProfileBaseProperties.class);
    protected Properties p = new Properties();
    private File f;
    private String location;
    private InputStream is;

    @Deprecated
    ProfileBaseProperties(String path) {
        try {
            this.loadFromPath(path);
        }
        catch (IOException e) {
            log.warn("{} load failed.", (Object)path);
        }
    }

    ProfileBaseProperties(URL url) {
        try {
            this.is = url.openStream();
            this.load();
        }
        catch (IOException e) {
            log.warn("{} load failed.", (Object)url);
        }
    }

    private void loadFromPath(String path) throws IOException {
        URL uri;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((uri = ProfileBaseProperties.class.getResource(path)) == null) {
            uri = Common.getResource(Common.trim(path, "/\\."), new ClassLoader[0]);
        }
        if (uri != null) {
            this.is = uri.openStream();
            this.load();
        }
    }

    private void load() {
        try {
            this.p.clear();
            if (this.is != null) {
                this.p.load(this.is);
                this.is.close();
            }
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    protected String getStringImpl(String key) {
        return this.p.getProperty(key);
    }

    @Override
    protected boolean isNull(String key) {
        return this.p.getProperty(key) == null;
    }
}

