/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.RenderService;
import org.coodex.util.SelectableServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Renderer {
    private static final Logger log = LoggerFactory.getLogger(Renderer.class);
    private static final SelectableServiceLoader<String, RenderService> RENDER_SERVICE_LOADER = new LazySelectableServiceLoader<String, RenderService>((RenderService)new DefaultRenderer()){};

    public static String render(String template, Object ... objects) {
        RenderService renderService = RENDER_SERVICE_LOADER.select(template);
        try {
            return RENDER_SERVICE_LOADER.select(template).render(template, objects);
        }
        catch (Throwable th) {
            log.warn("render failed: [RenderService: {}, template: {}]", new Object[]{renderService, template, th});
            throw Common.rte(th);
        }
    }

    static class DefaultRenderer
    implements RenderService {
        DefaultRenderer() {
        }

        @Override
        public String render(String template, Object ... objects) {
            return template;
        }

        @Override
        public boolean accept(String param) {
            return true;
        }
    }
}

