/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Objects;

public interface Searchable<E> {
    default public int indexOf(int fromIndex, int toIndex, E[] elements) {
        int first;
        if (elements == null || elements.length == 0) {
            return fromIndex;
        }
        if (elements.length == 1) {
            return this.indexOf(fromIndex, toIndex, elements[0]);
        }
        int len = elements.length;
        if (fromIndex + len > toIndex) {
            return -1;
        }
        while (fromIndex + len <= toIndex && (first = this.indexOf(fromIndex, toIndex - len + 1, elements[0])) >= 0) {
            boolean ok = true;
            for (int i = 1; i < len; ++i) {
                if (Objects.equals(elements[i], this.get(first + i))) continue;
                ok = false;
                break;
            }
            if (ok) {
                return first;
            }
            fromIndex = first + 1;
        }
        return -1;
    }

    public int indexOf(int var1, int var2, E var3);

    public E get(int var1);

    public static interface Integers
    extends Searchable<Integer> {
        @Override
        default public int indexOf(int fromIndex, int toIndex, int[] elements) {
            if (elements == null || elements.length == 0) {
                return fromIndex;
            }
            Integer[] integers = new Integer[elements.length];
            int l = integers.length;
            for (int i = 0; i < l; ++i) {
                integers[i] = elements[i];
            }
            return this.indexOf(fromIndex, toIndex, integers);
        }
    }

    public static interface Bytes
    extends Searchable<Byte> {
        @Override
        default public int indexOf(int fromIndex, int toIndex, byte[] elements) {
            if (elements == null || elements.length == 0) {
                return fromIndex;
            }
            Byte[] bytes = new Byte[elements.length];
            int l = bytes.length;
            for (int i = 0; i < l; ++i) {
                bytes[i] = elements[i];
            }
            return this.indexOf(fromIndex, toIndex, bytes);
        }
    }
}

