/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util.clock;

import java.text.ParseException;
import org.coodex.config.Config;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.clock.AbstractClockAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClockAgent
extends AbstractClockAgent {
    private static final Logger log = LoggerFactory.getLogger(DefaultClockAgent.class);
    public static final String KEY_BASELINE = Clock.class.getName() + ".baseline";

    public DefaultClockAgent() {
        super(Clock.getMagnification(), DefaultClockAgent.getTheBaseLine(), Common.getSystemStart());
    }

    private static long getTheBaseLine() {
        Long l = DefaultClockAgent.toBaseLine(Config.get(KEY_BASELINE, "clock"));
        if (l == null) {
            l = DefaultClockAgent.toBaseLine(System.getProperty(KEY_BASELINE));
        }
        return l == null ? Common.getSystemStart().longValue() : l.longValue();
    }

    private static Long toBaseLine(String str) {
        if (!Common.isBlank(str) && !str.equalsIgnoreCase("now")) {
            try {
                return Common.strToDate(str).getTime();
            }
            catch (ParseException e) {
                log.warn("baseline parse error: {}", (Object)str, (Object)e);
            }
        }
        return null;
    }
}

