/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.testcase.start;

import java.util.EventListener;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import org.coodex.concrete.spring.boot.EnableConcreteJAXRS;
import org.coodex.concrete.support.jsr339.ConcreteJSR339Application;
import org.coodex.concrete.support.websocket.CallerHackConfigurator;
import org.coodex.concrete.support.websocket.ConcreteWebSocketApplication;
import org.coodex.testcase.api.TestCase;
import org.coodex.testcase.api.TestCase2;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;

@SpringBootApplication
@ImportResource(value={"classpath:testcase.xml"})
@EnableConcreteJAXRS(servicePackages={"org.coodex.**.api"})
public class SpringBootStarter {
    @Bean
    public ServletRegistrationBean webSocketServlet() {
        ServletContainer container = new ServletContainer();
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)container, new String[]{"/WebSocket"}){

            protected ServletRegistration.Dynamic addRegistration(String description, ServletContext servletContext) {
                servletContext.addListener((EventListener)new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        ServerContainer serverContainer = (ServerContainer)sce.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
                        try {
                            serverContainer.addEndpoint(WebsocketApplication.class);
                        }
                        catch (DeploymentException e) {
                            e.printStackTrace();
                        }
                    }

                    public void contextDestroyed(ServletContextEvent sce) {
                    }
                });
                return super.addRegistration(description, servletContext);
            }
        };
        registrationBean.setName("demo");
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    public static void main(String[] args) {
        SpringApplication.run(SpringBootStarter.class, (String[])args);
    }

    @ServerEndpoint(value="/WebSocket", configurator=CallerHackConfigurator.class)
    public static class WebsocketApplication
    extends ConcreteWebSocketApplication {
        public WebsocketApplication() {
            this.register(new Class[]{TestCase.class, TestCase2.class});
        }
    }

    public static class JaxRSApplication
    extends ConcreteJSR339Application {
        public JaxRSApplication() {
            this.register(new Class[]{JacksonFeature.class});
            this.registerPackage(new String[0]);
        }
    }
}

