/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.performancetest.impl;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.copperengine.core.Acknowledge;
import org.copperengine.core.Callback;
import org.copperengine.core.ProcessingEngine;
import org.copperengine.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MockAdapter.class);
    private final int numberOfThreads;
    private ScheduledExecutorService pool;
    private int delay = 100;
    private ProcessingEngine engine;
    private AtomicInteger invokationCounter = new AtomicInteger(0);
    private static final Acknowledge bestEffortAck = new Acknowledge.BestEffortAcknowledge();

    public MockAdapter(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public void setEngine(ProcessingEngine engine) {
        this.engine = engine;
    }

    public void setDelayMSec(int delay) {
        this.delay = delay;
    }

    public void foo(final String param, final Callback<String> cb) {
        this.invokationCounter.incrementAndGet();
        if (this.delay <= 0) {
            cb.notify((Object)param, bestEffortAck);
        } else {
            this.pool.schedule(new Runnable(){

                @Override
                public void run() {
                    cb.notify((Object)param, bestEffortAck);
                }
            }, (long)this.delay, TimeUnit.MILLISECONDS);
        }
    }

    public void foo(String param, String cid) {
        this.foo(param, cid, this.delay);
    }

    public void foo(final String param, final String cid, int overrideDelay) {
        this.invokationCounter.incrementAndGet();
        if (overrideDelay <= 0) {
            this.engine.notify(new Response(cid, (Object)param, null), bestEffortAck);
        } else {
            this.pool.schedule(new Runnable(){

                @Override
                public void run() {
                    MockAdapter.this.engine.notify(new Response(cid, (Object)param, null), bestEffortAck);
                }
            }, (long)overrideDelay, TimeUnit.MILLISECONDS);
        }
    }

    public void fooWithMultiResponse(final String param, final String cid, final int numbOfResponse) {
        this.invokationCounter.incrementAndGet();
        this.pool.schedule(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < numbOfResponse; ++i) {
                    MockAdapter.this.engine.notify(new Response(cid, (Object)param, null), bestEffortAck);
                }
            }
        }, (long)this.delay, TimeUnit.MILLISECONDS);
    }

    public void incrementAsync(final int c, final String cid) {
        this.invokationCounter.incrementAndGet();
        if (this.delay <= 0) {
            this.engine.notify(new Response(cid, (Object)(c + 1), null), bestEffortAck);
        } else {
            this.pool.schedule(new Runnable(){

                @Override
                public void run() {
                    MockAdapter.this.engine.notify(new Response(cid, (Object)(c + 1), null), bestEffortAck);
                }
            }, (long)this.delay, TimeUnit.MILLISECONDS);
        }
    }

    public void incrementSync(int c, String cid) {
        this.invokationCounter.incrementAndGet();
        this.engine.notify(new Response(cid, (Object)(c + 1), null), bestEffortAck);
    }

    public synchronized void shutdown() {
        if (this.pool != null) {
            logger.debug("Shutting down...");
            this.pool.shutdown();
            this.pool = null;
        }
    }

    public int getInvokationCounter() {
        return this.invokationCounter.get();
    }

    public synchronized void startup() {
        if (this.pool == null) {
            logger.debug("Starting up...");
            this.pool = Executors.newScheduledThreadPool(this.numberOfThreads);
        }
    }

    public String foo(String param) {
        String cid = this.engine.createUUID();
        this.foo(param, cid);
        return cid;
    }
}

